<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurirtyQuestionsEntity StructType
 * @subpackage Structs
 */
class SecurirtyQuestionsEntity extends AbstractStructBase
{
    /**
     * The QuestionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuestionId;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreateUserId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The ConfirmTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfirmTypeId;
    /**
     * The IsConfirm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsConfirm;
    /**
     * The UpdateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UpdateId;
    /**
     * The UpdateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UpdateDate;
    /**
     * The UpdateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UpdateUserId;
    /**
     * The Question
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Question;
    /**
     * Constructor method for SecurirtyQuestionsEntity
     * @uses SecurirtyQuestionsEntity::setQuestionId()
     * @uses SecurirtyQuestionsEntity::setCreateUserId()
     * @uses SecurirtyQuestionsEntity::setCreateDate()
     * @uses SecurirtyQuestionsEntity::setIsDeleted()
     * @uses SecurirtyQuestionsEntity::setConfirmTypeId()
     * @uses SecurirtyQuestionsEntity::setIsConfirm()
     * @uses SecurirtyQuestionsEntity::setUpdateId()
     * @uses SecurirtyQuestionsEntity::setUpdateDate()
     * @uses SecurirtyQuestionsEntity::setUpdateUserId()
     * @uses SecurirtyQuestionsEntity::setQuestion()
     * @param int $questionId
     * @param int $createUserId
     * @param string $createDate
     * @param bool $isDeleted
     * @param int $confirmTypeId
     * @param bool $isConfirm
     * @param int $updateId
     * @param string $updateDate
     * @param int $updateUserId
     * @param string $question
     */
    public function __construct($questionId = null, $createUserId = null, $createDate = null, $isDeleted = null, $confirmTypeId = null, $isConfirm = null, $updateId = null, $updateDate = null, $updateUserId = null, $question = null)
    {
        $this
            ->setQuestionId($questionId)
            ->setCreateUserId($createUserId)
            ->setCreateDate($createDate)
            ->setIsDeleted($isDeleted)
            ->setConfirmTypeId($confirmTypeId)
            ->setIsConfirm($isConfirm)
            ->setUpdateId($updateId)
            ->setUpdateDate($updateDate)
            ->setUpdateUserId($updateUserId)
            ->setQuestion($question);
    }
    /**
     * Get QuestionId value
     * @return int
     */
    public function getQuestionId()
    {
        return $this->QuestionId;
    }
    /**
     * Set QuestionId value
     * @param int $questionId
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setQuestionId($questionId = null)
    {
        // validation for constraint: int
        if (!is_null($questionId) && !(is_int($questionId) || ctype_digit($questionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($questionId, true), gettype($questionId)), __LINE__);
        }
        $this->QuestionId = $questionId;
        return $this;
    }
    /**
     * Get CreateUserId value
     * @return int
     */
    public function getCreateUserId()
    {
        return $this->CreateUserId;
    }
    /**
     * Set CreateUserId value
     * @param int $createUserId
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: int
        if (!is_null($createUserId) && !(is_int($createUserId) || ctype_digit($createUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        $this->CreateUserId = $createUserId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get ConfirmTypeId value
     * @return int
     */
    public function getConfirmTypeId()
    {
        return $this->ConfirmTypeId;
    }
    /**
     * Set ConfirmTypeId value
     * @param int $confirmTypeId
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setConfirmTypeId($confirmTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($confirmTypeId) && !(is_int($confirmTypeId) || ctype_digit($confirmTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confirmTypeId, true), gettype($confirmTypeId)), __LINE__);
        }
        $this->ConfirmTypeId = $confirmTypeId;
        return $this;
    }
    /**
     * Get IsConfirm value
     * @return bool
     */
    public function getIsConfirm()
    {
        return $this->IsConfirm;
    }
    /**
     * Set IsConfirm value
     * @param bool $isConfirm
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setIsConfirm($isConfirm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirm) && !is_bool($isConfirm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirm, true), gettype($isConfirm)), __LINE__);
        }
        $this->IsConfirm = $isConfirm;
        return $this;
    }
    /**
     * Get UpdateId value
     * @return int
     */
    public function getUpdateId()
    {
        return $this->UpdateId;
    }
    /**
     * Set UpdateId value
     * @param int $updateId
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setUpdateId($updateId = null)
    {
        // validation for constraint: int
        if (!is_null($updateId) && !(is_int($updateId) || ctype_digit($updateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateId, true), gettype($updateId)), __LINE__);
        }
        $this->UpdateId = $updateId;
        return $this;
    }
    /**
     * Get UpdateDate value
     * @return string
     */
    public function getUpdateDate()
    {
        return $this->UpdateDate;
    }
    /**
     * Set UpdateDate value
     * @param string $updateDate
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        $this->UpdateDate = $updateDate;
        return $this;
    }
    /**
     * Get UpdateUserId value
     * @return int
     */
    public function getUpdateUserId()
    {
        return $this->UpdateUserId;
    }
    /**
     * Set UpdateUserId value
     * @param int $updateUserId
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setUpdateUserId($updateUserId = null)
    {
        // validation for constraint: int
        if (!is_null($updateUserId) && !(is_int($updateUserId) || ctype_digit($updateUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateUserId, true), gettype($updateUserId)), __LINE__);
        }
        $this->UpdateUserId = $updateUserId;
        return $this;
    }
    /**
     * Get Question value
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->Question;
    }
    /**
     * Set Question value
     * @param string $question
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question, true), gettype($question)), __LINE__);
        }
        $this->Question = $question;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecurirtyQuestionsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
