<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultOfListOfWalletsEntity StructType
 * @subpackage Structs
 */
class ResultOfListOfWalletsEntity extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultCode;
    /**
     * The ResultStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ResultStatus;
    /**
     * The ResultObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWalletsEntity
     */
    public $ResultObject;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The ResultInnerMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultInnerMessage;
    /**
     * Constructor method for ResultOfListOfWalletsEntity
     * @uses ResultOfListOfWalletsEntity::setResultCode()
     * @uses ResultOfListOfWalletsEntity::setResultStatus()
     * @uses ResultOfListOfWalletsEntity::setResultObject()
     * @uses ResultOfListOfWalletsEntity::setResultMessage()
     * @uses ResultOfListOfWalletsEntity::setResultInnerMessage()
     * @param int $resultCode
     * @param bool $resultStatus
     * @param \ArrayType\ArrayOfWalletsEntity $resultObject
     * @param string $resultMessage
     * @param string $resultInnerMessage
     */
    public function __construct($resultCode = null, $resultStatus = null, \ArrayType\ArrayOfWalletsEntity $resultObject = null, $resultMessage = null, $resultInnerMessage = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultStatus($resultStatus)
            ->setResultObject($resultObject)
            ->setResultMessage($resultMessage)
            ->setResultInnerMessage($resultInnerMessage);
    }
    /**
     * Get ResultCode value
     * @return int
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\ResultOfListOfWalletsEntity
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !(is_int($resultCode) || ctype_digit($resultCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultStatus value
     * @return bool
     */
    public function getResultStatus()
    {
        return $this->ResultStatus;
    }
    /**
     * Set ResultStatus value
     * @param bool $resultStatus
     * @return \StructType\ResultOfListOfWalletsEntity
     */
    public function setResultStatus($resultStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultStatus) && !is_bool($resultStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resultStatus, true), gettype($resultStatus)), __LINE__);
        }
        $this->ResultStatus = $resultStatus;
        return $this;
    }
    /**
     * Get ResultObject value
     * @return \ArrayType\ArrayOfWalletsEntity|null
     */
    public function getResultObject()
    {
        return $this->ResultObject;
    }
    /**
     * Set ResultObject value
     * @param \ArrayType\ArrayOfWalletsEntity $resultObject
     * @return \StructType\ResultOfListOfWalletsEntity
     */
    public function setResultObject(\ArrayType\ArrayOfWalletsEntity $resultObject = null)
    {
        $this->ResultObject = $resultObject;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \StructType\ResultOfListOfWalletsEntity
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get ResultInnerMessage value
     * @return string|null
     */
    public function getResultInnerMessage()
    {
        return $this->ResultInnerMessage;
    }
    /**
     * Set ResultInnerMessage value
     * @param string $resultInnerMessage
     * @return \StructType\ResultOfListOfWalletsEntity
     */
    public function setResultInnerMessage($resultInnerMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultInnerMessage) && !is_string($resultInnerMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultInnerMessage, true), gettype($resultInnerMessage)), __LINE__);
        }
        $this->ResultInnerMessage = $resultInnerMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultOfListOfWalletsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
