<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QrCodeEntity StructType
 * @subpackage Structs
 */
class QrCodeEntity extends AbstractStructBase
{
    /**
     * The ServiceTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceTypeId;
    /**
     * The JsonData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JsonData;
    /**
     * Constructor method for QrCodeEntity
     * @uses QrCodeEntity::setServiceTypeId()
     * @uses QrCodeEntity::setJsonData()
     * @param int $serviceTypeId
     * @param string $jsonData
     */
    public function __construct($serviceTypeId = null, $jsonData = null)
    {
        $this
            ->setServiceTypeId($serviceTypeId)
            ->setJsonData($jsonData);
    }
    /**
     * Get ServiceTypeId value
     * @return int
     */
    public function getServiceTypeId()
    {
        return $this->ServiceTypeId;
    }
    /**
     * Set ServiceTypeId value
     * @param int $serviceTypeId
     * @return \StructType\QrCodeEntity
     */
    public function setServiceTypeId($serviceTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceTypeId) && !(is_int($serviceTypeId) || ctype_digit($serviceTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceTypeId, true), gettype($serviceTypeId)), __LINE__);
        }
        $this->ServiceTypeId = $serviceTypeId;
        return $this;
    }
    /**
     * Get JsonData value
     * @return string|null
     */
    public function getJsonData()
    {
        return $this->JsonData;
    }
    /**
     * Set JsonData value
     * @param string $jsonData
     * @return \StructType\QrCodeEntity
     */
    public function setJsonData($jsonData = null)
    {
        // validation for constraint: string
        if (!is_null($jsonData) && !is_string($jsonData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jsonData, true), gettype($jsonData)), __LINE__);
        }
        $this->JsonData = $jsonData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QrCodeEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
