<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessagesEntity StructType
 * @subpackage Structs
 */
class MessagesEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The FromAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FromAccount;
    /**
     * The ToAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToAccount;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The UpdateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UpdateDate;
    /**
     * The IsDeletedTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeletedTo;
    /**
     * The IsDeletedFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeletedFrom;
    /**
     * The IsReadFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReadFrom;
    /**
     * The IsReadTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReadTo;
    /**
     * The IsInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInformation;
    /**
     * The IsConfirm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsConfirm;
    /**
     * The IsSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSend;
    /**
     * The IsRead
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRead;
    /**
     * The CreateDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateString;
    /**
     * The UpdateDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdateDateString;
    /**
     * The MessageCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageCode;
    /**
     * The MessageSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageSubject;
    /**
     * The MessageBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageBody;
    /**
     * The FromName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The ToName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToName;
    /**
     * Constructor method for MessagesEntity
     * @uses MessagesEntity::setId()
     * @uses MessagesEntity::setFromAccount()
     * @uses MessagesEntity::setToAccount()
     * @uses MessagesEntity::setCreateDate()
     * @uses MessagesEntity::setUpdateDate()
     * @uses MessagesEntity::setIsDeletedTo()
     * @uses MessagesEntity::setIsDeletedFrom()
     * @uses MessagesEntity::setIsReadFrom()
     * @uses MessagesEntity::setIsReadTo()
     * @uses MessagesEntity::setIsInformation()
     * @uses MessagesEntity::setIsConfirm()
     * @uses MessagesEntity::setIsSend()
     * @uses MessagesEntity::setIsRead()
     * @uses MessagesEntity::setCreateDateString()
     * @uses MessagesEntity::setUpdateDateString()
     * @uses MessagesEntity::setMessageCode()
     * @uses MessagesEntity::setMessageSubject()
     * @uses MessagesEntity::setMessageBody()
     * @uses MessagesEntity::setFromName()
     * @uses MessagesEntity::setToName()
     * @param int $id
     * @param int $fromAccount
     * @param int $toAccount
     * @param string $createDate
     * @param string $updateDate
     * @param bool $isDeletedTo
     * @param bool $isDeletedFrom
     * @param bool $isReadFrom
     * @param bool $isReadTo
     * @param bool $isInformation
     * @param bool $isConfirm
     * @param bool $isSend
     * @param bool $isRead
     * @param string $createDateString
     * @param string $updateDateString
     * @param string $messageCode
     * @param string $messageSubject
     * @param string $messageBody
     * @param string $fromName
     * @param string $toName
     */
    public function __construct($id = null, $fromAccount = null, $toAccount = null, $createDate = null, $updateDate = null, $isDeletedTo = null, $isDeletedFrom = null, $isReadFrom = null, $isReadTo = null, $isInformation = null, $isConfirm = null, $isSend = null, $isRead = null, $createDateString = null, $updateDateString = null, $messageCode = null, $messageSubject = null, $messageBody = null, $fromName = null, $toName = null)
    {
        $this
            ->setId($id)
            ->setFromAccount($fromAccount)
            ->setToAccount($toAccount)
            ->setCreateDate($createDate)
            ->setUpdateDate($updateDate)
            ->setIsDeletedTo($isDeletedTo)
            ->setIsDeletedFrom($isDeletedFrom)
            ->setIsReadFrom($isReadFrom)
            ->setIsReadTo($isReadTo)
            ->setIsInformation($isInformation)
            ->setIsConfirm($isConfirm)
            ->setIsSend($isSend)
            ->setIsRead($isRead)
            ->setCreateDateString($createDateString)
            ->setUpdateDateString($updateDateString)
            ->setMessageCode($messageCode)
            ->setMessageSubject($messageSubject)
            ->setMessageBody($messageBody)
            ->setFromName($fromName)
            ->setToName($toName);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\MessagesEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get FromAccount value
     * @return int
     */
    public function getFromAccount()
    {
        return $this->FromAccount;
    }
    /**
     * Set FromAccount value
     * @param int $fromAccount
     * @return \StructType\MessagesEntity
     */
    public function setFromAccount($fromAccount = null)
    {
        // validation for constraint: int
        if (!is_null($fromAccount) && !(is_int($fromAccount) || ctype_digit($fromAccount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromAccount, true), gettype($fromAccount)), __LINE__);
        }
        $this->FromAccount = $fromAccount;
        return $this;
    }
    /**
     * Get ToAccount value
     * @return int
     */
    public function getToAccount()
    {
        return $this->ToAccount;
    }
    /**
     * Set ToAccount value
     * @param int $toAccount
     * @return \StructType\MessagesEntity
     */
    public function setToAccount($toAccount = null)
    {
        // validation for constraint: int
        if (!is_null($toAccount) && !(is_int($toAccount) || ctype_digit($toAccount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toAccount, true), gettype($toAccount)), __LINE__);
        }
        $this->ToAccount = $toAccount;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\MessagesEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get UpdateDate value
     * @return string
     */
    public function getUpdateDate()
    {
        return $this->UpdateDate;
    }
    /**
     * Set UpdateDate value
     * @param string $updateDate
     * @return \StructType\MessagesEntity
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        $this->UpdateDate = $updateDate;
        return $this;
    }
    /**
     * Get IsDeletedTo value
     * @return bool
     */
    public function getIsDeletedTo()
    {
        return $this->IsDeletedTo;
    }
    /**
     * Set IsDeletedTo value
     * @param bool $isDeletedTo
     * @return \StructType\MessagesEntity
     */
    public function setIsDeletedTo($isDeletedTo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeletedTo) && !is_bool($isDeletedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeletedTo, true), gettype($isDeletedTo)), __LINE__);
        }
        $this->IsDeletedTo = $isDeletedTo;
        return $this;
    }
    /**
     * Get IsDeletedFrom value
     * @return bool
     */
    public function getIsDeletedFrom()
    {
        return $this->IsDeletedFrom;
    }
    /**
     * Set IsDeletedFrom value
     * @param bool $isDeletedFrom
     * @return \StructType\MessagesEntity
     */
    public function setIsDeletedFrom($isDeletedFrom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeletedFrom) && !is_bool($isDeletedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeletedFrom, true), gettype($isDeletedFrom)), __LINE__);
        }
        $this->IsDeletedFrom = $isDeletedFrom;
        return $this;
    }
    /**
     * Get IsReadFrom value
     * @return bool
     */
    public function getIsReadFrom()
    {
        return $this->IsReadFrom;
    }
    /**
     * Set IsReadFrom value
     * @param bool $isReadFrom
     * @return \StructType\MessagesEntity
     */
    public function setIsReadFrom($isReadFrom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadFrom) && !is_bool($isReadFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadFrom, true), gettype($isReadFrom)), __LINE__);
        }
        $this->IsReadFrom = $isReadFrom;
        return $this;
    }
    /**
     * Get IsReadTo value
     * @return bool
     */
    public function getIsReadTo()
    {
        return $this->IsReadTo;
    }
    /**
     * Set IsReadTo value
     * @param bool $isReadTo
     * @return \StructType\MessagesEntity
     */
    public function setIsReadTo($isReadTo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadTo) && !is_bool($isReadTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadTo, true), gettype($isReadTo)), __LINE__);
        }
        $this->IsReadTo = $isReadTo;
        return $this;
    }
    /**
     * Get IsInformation value
     * @return bool
     */
    public function getIsInformation()
    {
        return $this->IsInformation;
    }
    /**
     * Set IsInformation value
     * @param bool $isInformation
     * @return \StructType\MessagesEntity
     */
    public function setIsInformation($isInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInformation) && !is_bool($isInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInformation, true), gettype($isInformation)), __LINE__);
        }
        $this->IsInformation = $isInformation;
        return $this;
    }
    /**
     * Get IsConfirm value
     * @return bool
     */
    public function getIsConfirm()
    {
        return $this->IsConfirm;
    }
    /**
     * Set IsConfirm value
     * @param bool $isConfirm
     * @return \StructType\MessagesEntity
     */
    public function setIsConfirm($isConfirm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirm) && !is_bool($isConfirm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirm, true), gettype($isConfirm)), __LINE__);
        }
        $this->IsConfirm = $isConfirm;
        return $this;
    }
    /**
     * Get IsSend value
     * @return bool
     */
    public function getIsSend()
    {
        return $this->IsSend;
    }
    /**
     * Set IsSend value
     * @param bool $isSend
     * @return \StructType\MessagesEntity
     */
    public function setIsSend($isSend = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSend) && !is_bool($isSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSend, true), gettype($isSend)), __LINE__);
        }
        $this->IsSend = $isSend;
        return $this;
    }
    /**
     * Get IsRead value
     * @return bool
     */
    public function getIsRead()
    {
        return $this->IsRead;
    }
    /**
     * Set IsRead value
     * @param bool $isRead
     * @return \StructType\MessagesEntity
     */
    public function setIsRead($isRead = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRead) && !is_bool($isRead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRead, true), gettype($isRead)), __LINE__);
        }
        $this->IsRead = $isRead;
        return $this;
    }
    /**
     * Get CreateDateString value
     * @return string|null
     */
    public function getCreateDateString()
    {
        return $this->CreateDateString;
    }
    /**
     * Set CreateDateString value
     * @param string $createDateString
     * @return \StructType\MessagesEntity
     */
    public function setCreateDateString($createDateString = null)
    {
        // validation for constraint: string
        if (!is_null($createDateString) && !is_string($createDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateString, true), gettype($createDateString)), __LINE__);
        }
        $this->CreateDateString = $createDateString;
        return $this;
    }
    /**
     * Get UpdateDateString value
     * @return string|null
     */
    public function getUpdateDateString()
    {
        return $this->UpdateDateString;
    }
    /**
     * Set UpdateDateString value
     * @param string $updateDateString
     * @return \StructType\MessagesEntity
     */
    public function setUpdateDateString($updateDateString = null)
    {
        // validation for constraint: string
        if (!is_null($updateDateString) && !is_string($updateDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDateString, true), gettype($updateDateString)), __LINE__);
        }
        $this->UpdateDateString = $updateDateString;
        return $this;
    }
    /**
     * Get MessageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->MessageCode;
    }
    /**
     * Set MessageCode value
     * @param string $messageCode
     * @return \StructType\MessagesEntity
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageCode, true), gettype($messageCode)), __LINE__);
        }
        $this->MessageCode = $messageCode;
        return $this;
    }
    /**
     * Get MessageSubject value
     * @return string|null
     */
    public function getMessageSubject()
    {
        return $this->MessageSubject;
    }
    /**
     * Set MessageSubject value
     * @param string $messageSubject
     * @return \StructType\MessagesEntity
     */
    public function setMessageSubject($messageSubject = null)
    {
        // validation for constraint: string
        if (!is_null($messageSubject) && !is_string($messageSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageSubject, true), gettype($messageSubject)), __LINE__);
        }
        $this->MessageSubject = $messageSubject;
        return $this;
    }
    /**
     * Get MessageBody value
     * @return string|null
     */
    public function getMessageBody()
    {
        return $this->MessageBody;
    }
    /**
     * Set MessageBody value
     * @param string $messageBody
     * @return \StructType\MessagesEntity
     */
    public function setMessageBody($messageBody = null)
    {
        // validation for constraint: string
        if (!is_null($messageBody) && !is_string($messageBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageBody, true), gettype($messageBody)), __LINE__);
        }
        $this->MessageBody = $messageBody;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \StructType\MessagesEntity
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromName, true), gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get ToName value
     * @return string|null
     */
    public function getToName()
    {
        return $this->ToName;
    }
    /**
     * Set ToName value
     * @param string $toName
     * @return \StructType\MessagesEntity
     */
    public function setToName($toName = null)
    {
        // validation for constraint: string
        if (!is_null($toName) && !is_string($toName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toName, true), gettype($toName)), __LINE__);
        }
        $this->ToName = $toName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessagesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
