<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $longitude;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountriesEntity
     */
    public $Country;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CitiesEntity
     */
    public $City;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountiesEntity
     */
    public $County;
    /**
     * Constructor method for Location
     * @uses Location::setLatitude()
     * @uses Location::setLongitude()
     * @uses Location::setCountry()
     * @uses Location::setCity()
     * @uses Location::setCounty()
     * @param string $latitude
     * @param string $longitude
     * @param \StructType\CountriesEntity $country
     * @param \StructType\CitiesEntity $city
     * @param \StructType\CountiesEntity $county
     */
    public function __construct($latitude = null, $longitude = null, \StructType\CountriesEntity $country = null, \StructType\CitiesEntity $city = null, \StructType\CountiesEntity $county = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setCountry($country)
            ->setCity($city)
            ->setCounty($county);
    }
    /**
     * Get latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param string $latitude
     * @return \StructType\Location
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param string $longitude
     * @return \StructType\Location
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CountriesEntity|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountriesEntity $country
     * @return \StructType\Location
     */
    public function setCountry(\StructType\CountriesEntity $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get City value
     * @return \StructType\CitiesEntity|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \StructType\CitiesEntity $city
     * @return \StructType\Location
     */
    public function setCity(\StructType\CitiesEntity $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get County value
     * @return \StructType\CountiesEntity|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param \StructType\CountiesEntity $county
     * @return \StructType\Location
     */
    public function setCounty(\StructType\CountiesEntity $county = null)
    {
        $this->County = $county;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
