<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadMoneywithBankTransferControl StructType
 * @subpackage Structs
 */
class LoadMoneywithBankTransferControl extends AbstractStructBase
{
    /**
     * The bankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $bankId;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletCode;
    /**
     * The amount2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $amount2;
    /**
     * Constructor method for LoadMoneywithBankTransferControl
     * @uses LoadMoneywithBankTransferControl::setBankId()
     * @uses LoadMoneywithBankTransferControl::setAmount()
     * @uses LoadMoneywithBankTransferControl::setTokenId()
     * @uses LoadMoneywithBankTransferControl::setWalletCode()
     * @uses LoadMoneywithBankTransferControl::setAmount2()
     * @param int $bankId
     * @param int $amount
     * @param string $tokenId
     * @param string $walletCode
     * @param string $amount2
     */
    public function __construct($bankId = null, $amount = null, $tokenId = null, $walletCode = null, $amount2 = null)
    {
        $this
            ->setBankId($bankId)
            ->setAmount($amount)
            ->setTokenId($tokenId)
            ->setWalletCode($walletCode)
            ->setAmount2($amount2);
    }
    /**
     * Get bankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->bankId;
    }
    /**
     * Set bankId value
     * @param int $bankId
     * @return \StructType\LoadMoneywithBankTransferControl
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->bankId = $bankId;
        return $this;
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\LoadMoneywithBankTransferControl
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\LoadMoneywithBankTransferControl
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletCode value
     * @return string|null
     */
    public function getWalletCode()
    {
        return $this->walletCode;
    }
    /**
     * Set walletCode value
     * @param string $walletCode
     * @return \StructType\LoadMoneywithBankTransferControl
     */
    public function setWalletCode($walletCode = null)
    {
        // validation for constraint: string
        if (!is_null($walletCode) && !is_string($walletCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletCode, true), gettype($walletCode)), __LINE__);
        }
        $this->walletCode = $walletCode;
        return $this;
    }
    /**
     * Get amount2 value
     * @return string|null
     */
    public function getAmount2()
    {
        return $this->amount2;
    }
    /**
     * Set amount2 value
     * @param string $amount2
     * @return \StructType\LoadMoneywithBankTransferControl
     */
    public function setAmount2($amount2 = null)
    {
        // validation for constraint: string
        if (!is_null($amount2) && !is_string($amount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount2, true), gettype($amount2)), __LINE__);
        }
        $this->amount2 = $amount2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoadMoneywithBankTransferControl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
