<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadMoneyEntity StructType
 * @subpackage Structs
 */
class LoadMoneyEntity extends AbstractStructBase
{
    /**
     * The AccountOwner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountOwner;
    /**
     * The Bank
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BanksEntity
     */
    public $Bank;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MerchantBranchListEntity
     */
    public $Branch;
    /**
     * The Transaction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransactionsEntity
     */
    public $Transaction;
    /**
     * Constructor method for LoadMoneyEntity
     * @uses LoadMoneyEntity::setAccountOwner()
     * @uses LoadMoneyEntity::setBank()
     * @uses LoadMoneyEntity::setBranch()
     * @uses LoadMoneyEntity::setTransaction()
     * @param string $accountOwner
     * @param \StructType\BanksEntity $bank
     * @param \StructType\MerchantBranchListEntity $branch
     * @param \StructType\TransactionsEntity $transaction
     */
    public function __construct($accountOwner = null, \StructType\BanksEntity $bank = null, \StructType\MerchantBranchListEntity $branch = null, \StructType\TransactionsEntity $transaction = null)
    {
        $this
            ->setAccountOwner($accountOwner)
            ->setBank($bank)
            ->setBranch($branch)
            ->setTransaction($transaction);
    }
    /**
     * Get AccountOwner value
     * @return string|null
     */
    public function getAccountOwner()
    {
        return $this->AccountOwner;
    }
    /**
     * Set AccountOwner value
     * @param string $accountOwner
     * @return \StructType\LoadMoneyEntity
     */
    public function setAccountOwner($accountOwner = null)
    {
        // validation for constraint: string
        if (!is_null($accountOwner) && !is_string($accountOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountOwner, true), gettype($accountOwner)), __LINE__);
        }
        $this->AccountOwner = $accountOwner;
        return $this;
    }
    /**
     * Get Bank value
     * @return \StructType\BanksEntity|null
     */
    public function getBank()
    {
        return $this->Bank;
    }
    /**
     * Set Bank value
     * @param \StructType\BanksEntity $bank
     * @return \StructType\LoadMoneyEntity
     */
    public function setBank(\StructType\BanksEntity $bank = null)
    {
        $this->Bank = $bank;
        return $this;
    }
    /**
     * Get Branch value
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \StructType\MerchantBranchListEntity $branch
     * @return \StructType\LoadMoneyEntity
     */
    public function setBranch(\StructType\MerchantBranchListEntity $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get Transaction value
     * @return \StructType\TransactionsEntity|null
     */
    public function getTransaction()
    {
        return $this->Transaction;
    }
    /**
     * Set Transaction value
     * @param \StructType\TransactionsEntity $transaction
     * @return \StructType\LoadMoneyEntity
     */
    public function setTransaction(\StructType\TransactionsEntity $transaction = null)
    {
        $this->Transaction = $transaction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoadMoneyEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
