<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstitutionFieldsEntity StructType
 * @subpackage Structs
 */
class InstitutionFieldsEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The InstitutionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InstitutionId;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Required;
    /**
     * The MinLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinLength;
    /**
     * The MaxLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxLength;
    /**
     * The LabelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelName;
    /**
     * Constructor method for InstitutionFieldsEntity
     * @uses InstitutionFieldsEntity::setId()
     * @uses InstitutionFieldsEntity::setInstitutionId()
     * @uses InstitutionFieldsEntity::setRequired()
     * @uses InstitutionFieldsEntity::setMinLength()
     * @uses InstitutionFieldsEntity::setMaxLength()
     * @uses InstitutionFieldsEntity::setLabelName()
     * @param int $id
     * @param int $institutionId
     * @param bool $required
     * @param int $minLength
     * @param int $maxLength
     * @param string $labelName
     */
    public function __construct($id = null, $institutionId = null, $required = null, $minLength = null, $maxLength = null, $labelName = null)
    {
        $this
            ->setId($id)
            ->setInstitutionId($institutionId)
            ->setRequired($required)
            ->setMinLength($minLength)
            ->setMaxLength($maxLength)
            ->setLabelName($labelName);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\InstitutionFieldsEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get InstitutionId value
     * @return int
     */
    public function getInstitutionId()
    {
        return $this->InstitutionId;
    }
    /**
     * Set InstitutionId value
     * @param int $institutionId
     * @return \StructType\InstitutionFieldsEntity
     */
    public function setInstitutionId($institutionId = null)
    {
        // validation for constraint: int
        if (!is_null($institutionId) && !(is_int($institutionId) || ctype_digit($institutionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($institutionId, true), gettype($institutionId)), __LINE__);
        }
        $this->InstitutionId = $institutionId;
        return $this;
    }
    /**
     * Get Required value
     * @return bool
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\InstitutionFieldsEntity
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get MinLength value
     * @return int
     */
    public function getMinLength()
    {
        return $this->MinLength;
    }
    /**
     * Set MinLength value
     * @param int $minLength
     * @return \StructType\InstitutionFieldsEntity
     */
    public function setMinLength($minLength = null)
    {
        // validation for constraint: int
        if (!is_null($minLength) && !(is_int($minLength) || ctype_digit($minLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minLength, true), gettype($minLength)), __LINE__);
        }
        $this->MinLength = $minLength;
        return $this;
    }
    /**
     * Get MaxLength value
     * @return int
     */
    public function getMaxLength()
    {
        return $this->MaxLength;
    }
    /**
     * Set MaxLength value
     * @param int $maxLength
     * @return \StructType\InstitutionFieldsEntity
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: int
        if (!is_null($maxLength) && !(is_int($maxLength) || ctype_digit($maxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxLength, true), gettype($maxLength)), __LINE__);
        }
        $this->MaxLength = $maxLength;
        return $this;
    }
    /**
     * Get LabelName value
     * @return string|null
     */
    public function getLabelName()
    {
        return $this->LabelName;
    }
    /**
     * Set LabelName value
     * @param string $labelName
     * @return \StructType\InstitutionFieldsEntity
     */
    public function setLabelName($labelName = null)
    {
        // validation for constraint: string
        if (!is_null($labelName) && !is_string($labelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelName, true), gettype($labelName)), __LINE__);
        }
        $this->LabelName = $labelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InstitutionFieldsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
