<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentityControl StructType
 * @subpackage Structs
 */
class IdentityControl extends AbstractStructBase
{
    /**
     * The TcNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TcNo;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The surName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $surName;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * Constructor method for IdentityControl
     * @uses IdentityControl::setTcNo()
     * @uses IdentityControl::setTokenId()
     * @uses IdentityControl::setName()
     * @uses IdentityControl::setSurName()
     * @uses IdentityControl::setBirthDate()
     * @param int $tcNo
     * @param string $tokenId
     * @param string $name
     * @param string $surName
     * @param string $birthDate
     */
    public function __construct($tcNo = null, $tokenId = null, $name = null, $surName = null, $birthDate = null)
    {
        $this
            ->setTcNo($tcNo)
            ->setTokenId($tokenId)
            ->setName($name)
            ->setSurName($surName)
            ->setBirthDate($birthDate);
    }
    /**
     * Get TcNo value
     * @return int
     */
    public function getTcNo()
    {
        return $this->TcNo;
    }
    /**
     * Set TcNo value
     * @param int $tcNo
     * @return \StructType\IdentityControl
     */
    public function setTcNo($tcNo = null)
    {
        // validation for constraint: int
        if (!is_null($tcNo) && !(is_int($tcNo) || ctype_digit($tcNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tcNo, true), gettype($tcNo)), __LINE__);
        }
        $this->TcNo = $tcNo;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\IdentityControl
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\IdentityControl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get surName value
     * @return string|null
     */
    public function getSurName()
    {
        return $this->surName;
    }
    /**
     * Set surName value
     * @param string $surName
     * @return \StructType\IdentityControl
     */
    public function setSurName($surName = null)
    {
        // validation for constraint: string
        if (!is_null($surName) && !is_string($surName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surName, true), gettype($surName)), __LINE__);
        }
        $this->surName = $surName;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\IdentityControl
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentityControl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
