<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionList StructType
 * @subpackage Structs
 */
class GetTransactionList extends AbstractStructBase
{
    /**
     * The dateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dateType;
    /**
     * The page
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $page;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletcode;
    /**
     * Constructor method for GetTransactionList
     * @uses GetTransactionList::setDateType()
     * @uses GetTransactionList::setPage()
     * @uses GetTransactionList::setTokenId()
     * @uses GetTransactionList::setWalletcode()
     * @param int $dateType
     * @param int $page
     * @param string $tokenId
     * @param string $walletcode
     */
    public function __construct($dateType = null, $page = null, $tokenId = null, $walletcode = null)
    {
        $this
            ->setDateType($dateType)
            ->setPage($page)
            ->setTokenId($tokenId)
            ->setWalletcode($walletcode);
    }
    /**
     * Get dateType value
     * @return int
     */
    public function getDateType()
    {
        return $this->dateType;
    }
    /**
     * Set dateType value
     * @param int $dateType
     * @return \StructType\GetTransactionList
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: int
        if (!is_null($dateType) && !(is_int($dateType) || ctype_digit($dateType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dateType, true), gettype($dateType)), __LINE__);
        }
        $this->dateType = $dateType;
        return $this;
    }
    /**
     * Get page value
     * @return int
     */
    public function getPage()
    {
        return $this->page;
    }
    /**
     * Set page value
     * @param int $page
     * @return \StructType\GetTransactionList
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->page = $page;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\GetTransactionList
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletcode value
     * @return string|null
     */
    public function getWalletcode()
    {
        return $this->walletcode;
    }
    /**
     * Set walletcode value
     * @param string $walletcode
     * @return \StructType\GetTransactionList
     */
    public function setWalletcode($walletcode = null)
    {
        // validation for constraint: string
        if (!is_null($walletcode) && !is_string($walletcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletcode, true), gettype($walletcode)), __LINE__);
        }
        $this->walletcode = $walletcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTransactionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
