<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBankDetail StructType
 * @subpackage Structs
 */
class GetBankDetail extends AbstractStructBase
{
    /**
     * The bankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $bankId;
    /**
     * Constructor method for GetBankDetail
     * @uses GetBankDetail::setBankId()
     * @param int $bankId
     */
    public function __construct($bankId = null)
    {
        $this
            ->setBankId($bankId);
    }
    /**
     * Get bankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->bankId;
    }
    /**
     * Set bankId value
     * @param int $bankId
     * @return \StructType\GetBankDetail
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->bankId = $bankId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBankDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
