<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyTypesEntity StructType
 * @subpackage Structs
 */
class CurrencyTypesEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The MinorUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinorUnit;
    /**
     * The CurencyOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurencyOrder;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The Symbol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Symbol;
    /**
     * Constructor method for CurrencyTypesEntity
     * @uses CurrencyTypesEntity::setId()
     * @uses CurrencyTypesEntity::setCode()
     * @uses CurrencyTypesEntity::setMinorUnit()
     * @uses CurrencyTypesEntity::setCurencyOrder()
     * @uses CurrencyTypesEntity::setCountry()
     * @uses CurrencyTypesEntity::setName()
     * @uses CurrencyTypesEntity::setShortName()
     * @uses CurrencyTypesEntity::setSymbol()
     * @param int $id
     * @param int $code
     * @param int $minorUnit
     * @param int $curencyOrder
     * @param string $country
     * @param string $name
     * @param string $shortName
     * @param string $symbol
     */
    public function __construct($id = null, $code = null, $minorUnit = null, $curencyOrder = null, $country = null, $name = null, $shortName = null, $symbol = null)
    {
        $this
            ->setId($id)
            ->setCode($code)
            ->setMinorUnit($minorUnit)
            ->setCurencyOrder($curencyOrder)
            ->setCountry($country)
            ->setName($name)
            ->setShortName($shortName)
            ->setSymbol($symbol);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\CurrencyTypesEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\CurrencyTypesEntity
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get MinorUnit value
     * @return int
     */
    public function getMinorUnit()
    {
        return $this->MinorUnit;
    }
    /**
     * Set MinorUnit value
     * @param int $minorUnit
     * @return \StructType\CurrencyTypesEntity
     */
    public function setMinorUnit($minorUnit = null)
    {
        // validation for constraint: int
        if (!is_null($minorUnit) && !(is_int($minorUnit) || ctype_digit($minorUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minorUnit, true), gettype($minorUnit)), __LINE__);
        }
        $this->MinorUnit = $minorUnit;
        return $this;
    }
    /**
     * Get CurencyOrder value
     * @return int
     */
    public function getCurencyOrder()
    {
        return $this->CurencyOrder;
    }
    /**
     * Set CurencyOrder value
     * @param int $curencyOrder
     * @return \StructType\CurrencyTypesEntity
     */
    public function setCurencyOrder($curencyOrder = null)
    {
        // validation for constraint: int
        if (!is_null($curencyOrder) && !(is_int($curencyOrder) || ctype_digit($curencyOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($curencyOrder, true), gettype($curencyOrder)), __LINE__);
        }
        $this->CurencyOrder = $curencyOrder;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\CurrencyTypesEntity
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CurrencyTypesEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \StructType\CurrencyTypesEntity
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get Symbol value
     * @return string|null
     */
    public function getSymbol()
    {
        return $this->Symbol;
    }
    /**
     * Set Symbol value
     * @param string $symbol
     * @return \StructType\CurrencyTypesEntity
     */
    public function setSymbol($symbol = null)
    {
        // validation for constraint: string
        if (!is_null($symbol) && !is_string($symbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($symbol, true), gettype($symbol)), __LINE__);
        }
        $this->Symbol = $symbol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyTypesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
