<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateMobilePin StructType
 * @subpackage Structs
 */
class CreateMobilePin extends AbstractStructBase
{
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pin;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The deviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceKey;
    /**
     * Constructor method for CreateMobilePin
     * @uses CreateMobilePin::setPin()
     * @uses CreateMobilePin::setTokenId()
     * @uses CreateMobilePin::setDeviceKey()
     * @param int $pin
     * @param string $tokenId
     * @param string $deviceKey
     */
    public function __construct($pin = null, $tokenId = null, $deviceKey = null)
    {
        $this
            ->setPin($pin)
            ->setTokenId($tokenId)
            ->setDeviceKey($deviceKey);
    }
    /**
     * Get pin value
     * @return int
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param int $pin
     * @return \StructType\CreateMobilePin
     */
    public function setPin($pin = null)
    {
        // validation for constraint: int
        if (!is_null($pin) && !(is_int($pin) || ctype_digit($pin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\CreateMobilePin
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get deviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->deviceKey;
    }
    /**
     * Set deviceKey value
     * @param string $deviceKey
     * @return \StructType\CreateMobilePin
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->deviceKey = $deviceKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateMobilePin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
