<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountiesEntity StructType
 * @subpackage Structs
 */
class CountiesEntity extends AbstractStructBase
{
    /**
     * The CountyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountyId;
    /**
     * The CityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CityId;
    /**
     * The CountyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountyName;
    /**
     * Constructor method for CountiesEntity
     * @uses CountiesEntity::setCountyId()
     * @uses CountiesEntity::setCityId()
     * @uses CountiesEntity::setCountyName()
     * @param int $countyId
     * @param int $cityId
     * @param string $countyName
     */
    public function __construct($countyId = null, $cityId = null, $countyName = null)
    {
        $this
            ->setCountyId($countyId)
            ->setCityId($cityId)
            ->setCountyName($countyName);
    }
    /**
     * Get CountyId value
     * @return int
     */
    public function getCountyId()
    {
        return $this->CountyId;
    }
    /**
     * Set CountyId value
     * @param int $countyId
     * @return \StructType\CountiesEntity
     */
    public function setCountyId($countyId = null)
    {
        // validation for constraint: int
        if (!is_null($countyId) && !(is_int($countyId) || ctype_digit($countyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countyId, true), gettype($countyId)), __LINE__);
        }
        $this->CountyId = $countyId;
        return $this;
    }
    /**
     * Get CityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->CityId;
    }
    /**
     * Set CityId value
     * @param int $cityId
     * @return \StructType\CountiesEntity
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !(is_int($cityId) || ctype_digit($cityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        $this->CityId = $cityId;
        return $this;
    }
    /**
     * Get CountyName value
     * @return string|null
     */
    public function getCountyName()
    {
        return $this->CountyName;
    }
    /**
     * Set CountyName value
     * @param string $countyName
     * @return \StructType\CountiesEntity
     */
    public function setCountyName($countyName = null)
    {
        // validation for constraint: string
        if (!is_null($countyName) && !is_string($countyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countyName, true), gettype($countyName)), __LINE__);
        }
        $this->CountyName = $countyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountiesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
