<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDeviceVersionControl StructType
 * @subpackage Structs
 */
class CheckDeviceVersionControl extends AbstractStructBase
{
    /**
     * The IsIos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIos;
    /**
     * The deviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceKey;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * Constructor method for CheckDeviceVersionControl
     * @uses CheckDeviceVersionControl::setIsIos()
     * @uses CheckDeviceVersionControl::setDeviceKey()
     * @uses CheckDeviceVersionControl::setVersion()
     * @param bool $isIos
     * @param string $deviceKey
     * @param string $version
     */
    public function __construct($isIos = null, $deviceKey = null, $version = null)
    {
        $this
            ->setIsIos($isIos)
            ->setDeviceKey($deviceKey)
            ->setVersion($version);
    }
    /**
     * Get IsIos value
     * @return bool
     */
    public function getIsIos()
    {
        return $this->IsIos;
    }
    /**
     * Set IsIos value
     * @param bool $isIos
     * @return \StructType\CheckDeviceVersionControl
     */
    public function setIsIos($isIos = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIos) && !is_bool($isIos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIos, true), gettype($isIos)), __LINE__);
        }
        $this->IsIos = $isIos;
        return $this;
    }
    /**
     * Get deviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->deviceKey;
    }
    /**
     * Set deviceKey value
     * @param string $deviceKey
     * @return \StructType\CheckDeviceVersionControl
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->deviceKey = $deviceKey;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\CheckDeviceVersionControl
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckDeviceVersionControl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
