<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BranchMoneyTransactionEntity StructType
 * @subpackage Structs
 */
class BranchMoneyTransactionEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateString;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MerchantBranchListEntity
     */
    public $Branch;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * The TransactionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionCode;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for BranchMoneyTransactionEntity
     * @uses BranchMoneyTransactionEntity::setId()
     * @uses BranchMoneyTransactionEntity::setAmount()
     * @uses BranchMoneyTransactionEntity::setCreateDate()
     * @uses BranchMoneyTransactionEntity::setCreateDateString()
     * @uses BranchMoneyTransactionEntity::setBranch()
     * @uses BranchMoneyTransactionEntity::setBranchName()
     * @uses BranchMoneyTransactionEntity::setTransactionCode()
     * @uses BranchMoneyTransactionEntity::setTransactionId()
     * @param int $id
     * @param float $amount
     * @param string $createDate
     * @param string $createDateString
     * @param \StructType\MerchantBranchListEntity $branch
     * @param string $branchName
     * @param string $transactionCode
     * @param string $transactionId
     */
    public function __construct($id = null, $amount = null, $createDate = null, $createDateString = null, \StructType\MerchantBranchListEntity $branch = null, $branchName = null, $transactionCode = null, $transactionId = null)
    {
        $this
            ->setId($id)
            ->setAmount($amount)
            ->setCreateDate($createDate)
            ->setCreateDateString($createDateString)
            ->setBranch($branch)
            ->setBranchName($branchName)
            ->setTransactionCode($transactionCode)
            ->setTransactionId($transactionId);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateDateString value
     * @return string|null
     */
    public function getCreateDateString()
    {
        return $this->CreateDateString;
    }
    /**
     * Set CreateDateString value
     * @param string $createDateString
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setCreateDateString($createDateString = null)
    {
        // validation for constraint: string
        if (!is_null($createDateString) && !is_string($createDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateString, true), gettype($createDateString)), __LINE__);
        }
        $this->CreateDateString = $createDateString;
        return $this;
    }
    /**
     * Get Branch value
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \StructType\MerchantBranchListEntity $branch
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setBranch(\StructType\MerchantBranchListEntity $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
    /**
     * Get TransactionCode value
     * @return string|null
     */
    public function getTransactionCode()
    {
        return $this->TransactionCode;
    }
    /**
     * Set TransactionCode value
     * @param string $transactionCode
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setTransactionCode($transactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCode) && !is_string($transactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCode, true), gettype($transactionCode)), __LINE__);
        }
        $this->TransactionCode = $transactionCode;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BranchMoneyTransactionEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
