<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillList StructType
 * @subpackage Structs
 */
class BillList extends AbstractStructBase
{
    /**
     * The InquiryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InquiryId;
    /**
     * The InstitutionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionId;
    /**
     * The SubscriberNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberNo;
    /**
     * The SubscriberNo1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberNo1;
    /**
     * The SubscriberNo2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberNo2;
    /**
     * The SubscriberNo3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberNo3;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The OrderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNo;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalAmount;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Commission;
    /**
     * The LPD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LPD;
    /**
     * Constructor method for BillList
     * @uses BillList::setInquiryId()
     * @uses BillList::setInstitutionId()
     * @uses BillList::setSubscriberNo()
     * @uses BillList::setSubscriberNo1()
     * @uses BillList::setSubscriberNo2()
     * @uses BillList::setSubscriberNo3()
     * @uses BillList::setName()
     * @uses BillList::setOrderNo()
     * @uses BillList::setAmount()
     * @uses BillList::setTotalAmount()
     * @uses BillList::setCommission()
     * @uses BillList::setLPD()
     * @param int $inquiryId
     * @param string $institutionId
     * @param string $subscriberNo
     * @param string $subscriberNo1
     * @param string $subscriberNo2
     * @param string $subscriberNo3
     * @param string $name
     * @param string $orderNo
     * @param string $amount
     * @param string $totalAmount
     * @param string $commission
     * @param string $lPD
     */
    public function __construct($inquiryId = null, $institutionId = null, $subscriberNo = null, $subscriberNo1 = null, $subscriberNo2 = null, $subscriberNo3 = null, $name = null, $orderNo = null, $amount = null, $totalAmount = null, $commission = null, $lPD = null)
    {
        $this
            ->setInquiryId($inquiryId)
            ->setInstitutionId($institutionId)
            ->setSubscriberNo($subscriberNo)
            ->setSubscriberNo1($subscriberNo1)
            ->setSubscriberNo2($subscriberNo2)
            ->setSubscriberNo3($subscriberNo3)
            ->setName($name)
            ->setOrderNo($orderNo)
            ->setAmount($amount)
            ->setTotalAmount($totalAmount)
            ->setCommission($commission)
            ->setLPD($lPD);
    }
    /**
     * Get InquiryId value
     * @return int
     */
    public function getInquiryId()
    {
        return $this->InquiryId;
    }
    /**
     * Set InquiryId value
     * @param int $inquiryId
     * @return \StructType\BillList
     */
    public function setInquiryId($inquiryId = null)
    {
        // validation for constraint: int
        if (!is_null($inquiryId) && !(is_int($inquiryId) || ctype_digit($inquiryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inquiryId, true), gettype($inquiryId)), __LINE__);
        }
        $this->InquiryId = $inquiryId;
        return $this;
    }
    /**
     * Get InstitutionId value
     * @return string|null
     */
    public function getInstitutionId()
    {
        return $this->InstitutionId;
    }
    /**
     * Set InstitutionId value
     * @param string $institutionId
     * @return \StructType\BillList
     */
    public function setInstitutionId($institutionId = null)
    {
        // validation for constraint: string
        if (!is_null($institutionId) && !is_string($institutionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($institutionId, true), gettype($institutionId)), __LINE__);
        }
        $this->InstitutionId = $institutionId;
        return $this;
    }
    /**
     * Get SubscriberNo value
     * @return string|null
     */
    public function getSubscriberNo()
    {
        return $this->SubscriberNo;
    }
    /**
     * Set SubscriberNo value
     * @param string $subscriberNo
     * @return \StructType\BillList
     */
    public function setSubscriberNo($subscriberNo = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberNo) && !is_string($subscriberNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberNo, true), gettype($subscriberNo)), __LINE__);
        }
        $this->SubscriberNo = $subscriberNo;
        return $this;
    }
    /**
     * Get SubscriberNo1 value
     * @return string|null
     */
    public function getSubscriberNo1()
    {
        return $this->SubscriberNo1;
    }
    /**
     * Set SubscriberNo1 value
     * @param string $subscriberNo1
     * @return \StructType\BillList
     */
    public function setSubscriberNo1($subscriberNo1 = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberNo1) && !is_string($subscriberNo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberNo1, true), gettype($subscriberNo1)), __LINE__);
        }
        $this->SubscriberNo1 = $subscriberNo1;
        return $this;
    }
    /**
     * Get SubscriberNo2 value
     * @return string|null
     */
    public function getSubscriberNo2()
    {
        return $this->SubscriberNo2;
    }
    /**
     * Set SubscriberNo2 value
     * @param string $subscriberNo2
     * @return \StructType\BillList
     */
    public function setSubscriberNo2($subscriberNo2 = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberNo2) && !is_string($subscriberNo2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberNo2, true), gettype($subscriberNo2)), __LINE__);
        }
        $this->SubscriberNo2 = $subscriberNo2;
        return $this;
    }
    /**
     * Get SubscriberNo3 value
     * @return string|null
     */
    public function getSubscriberNo3()
    {
        return $this->SubscriberNo3;
    }
    /**
     * Set SubscriberNo3 value
     * @param string $subscriberNo3
     * @return \StructType\BillList
     */
    public function setSubscriberNo3($subscriberNo3 = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberNo3) && !is_string($subscriberNo3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberNo3, true), gettype($subscriberNo3)), __LINE__);
        }
        $this->SubscriberNo3 = $subscriberNo3;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BillList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OrderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->OrderNo;
    }
    /**
     * Set OrderNo value
     * @param string $orderNo
     * @return \StructType\BillList
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNo, true), gettype($orderNo)), __LINE__);
        }
        $this->OrderNo = $orderNo;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\BillList
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \StructType\BillList
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalAmount) && !is_string($totalAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get Commission value
     * @return string|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param string $commission
     * @return \StructType\BillList
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: string
        if (!is_null($commission) && !is_string($commission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get LPD value
     * @return string|null
     */
    public function getLPD()
    {
        return $this->LPD;
    }
    /**
     * Set LPD value
     * @param string $lPD
     * @return \StructType\BillList
     */
    public function setLPD($lPD = null)
    {
        // validation for constraint: string
        if (!is_null($lPD) && !is_string($lPD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lPD, true), gettype($lPD)), __LINE__);
        }
        $this->LPD = $lPD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
