<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccountsEntity StructType
 * @subpackage Structs
 */
class BankAccountsEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The BankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankId;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsVerification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVerification;
    /**
     * The VerificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VerificationDate;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The StatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusId;
    /**
     * The Iban
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Iban;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * Constructor method for BankAccountsEntity
     * @uses BankAccountsEntity::setId()
     * @uses BankAccountsEntity::setBankId()
     * @uses BankAccountsEntity::setAccountId()
     * @uses BankAccountsEntity::setCreateDate()
     * @uses BankAccountsEntity::setIsVerification()
     * @uses BankAccountsEntity::setVerificationDate()
     * @uses BankAccountsEntity::setIsActived()
     * @uses BankAccountsEntity::setIsDeleted()
     * @uses BankAccountsEntity::setStatusId()
     * @uses BankAccountsEntity::setIban()
     * @uses BankAccountsEntity::setAccountName()
     * @uses BankAccountsEntity::setBankName()
     * @uses BankAccountsEntity::setImageUrl()
     * @param int $id
     * @param int $bankId
     * @param int $accountId
     * @param string $createDate
     * @param bool $isVerification
     * @param string $verificationDate
     * @param bool $isActived
     * @param bool $isDeleted
     * @param int $statusId
     * @param string $iban
     * @param string $accountName
     * @param string $bankName
     * @param string $imageUrl
     */
    public function __construct($id = null, $bankId = null, $accountId = null, $createDate = null, $isVerification = null, $verificationDate = null, $isActived = null, $isDeleted = null, $statusId = null, $iban = null, $accountName = null, $bankName = null, $imageUrl = null)
    {
        $this
            ->setId($id)
            ->setBankId($bankId)
            ->setAccountId($accountId)
            ->setCreateDate($createDate)
            ->setIsVerification($isVerification)
            ->setVerificationDate($verificationDate)
            ->setIsActived($isActived)
            ->setIsDeleted($isDeleted)
            ->setStatusId($statusId)
            ->setIban($iban)
            ->setAccountName($accountName)
            ->setBankName($bankName)
            ->setImageUrl($imageUrl);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\BankAccountsEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get BankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->BankId;
    }
    /**
     * Set BankId value
     * @param int $bankId
     * @return \StructType\BankAccountsEntity
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->BankId = $bankId;
        return $this;
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\BankAccountsEntity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\BankAccountsEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsVerification value
     * @return bool
     */
    public function getIsVerification()
    {
        return $this->IsVerification;
    }
    /**
     * Set IsVerification value
     * @param bool $isVerification
     * @return \StructType\BankAccountsEntity
     */
    public function setIsVerification($isVerification = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerification) && !is_bool($isVerification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerification, true), gettype($isVerification)), __LINE__);
        }
        $this->IsVerification = $isVerification;
        return $this;
    }
    /**
     * Get VerificationDate value
     * @return string
     */
    public function getVerificationDate()
    {
        return $this->VerificationDate;
    }
    /**
     * Set VerificationDate value
     * @param string $verificationDate
     * @return \StructType\BankAccountsEntity
     */
    public function setVerificationDate($verificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($verificationDate) && !is_string($verificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verificationDate, true), gettype($verificationDate)), __LINE__);
        }
        $this->VerificationDate = $verificationDate;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\BankAccountsEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\BankAccountsEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get StatusId value
     * @return int
     */
    public function getStatusId()
    {
        return $this->StatusId;
    }
    /**
     * Set StatusId value
     * @param int $statusId
     * @return \StructType\BankAccountsEntity
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !(is_int($statusId) || ctype_digit($statusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        $this->StatusId = $statusId;
        return $this;
    }
    /**
     * Get Iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->Iban;
    }
    /**
     * Set Iban value
     * @param string $iban
     * @return \StructType\BankAccountsEntity
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->Iban = $iban;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\BankAccountsEntity
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\BankAccountsEntity
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\BankAccountsEntity
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAccountsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
