<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountIdentityEntity StructType
 * @subpackage Structs
 */
class AccountIdentityEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The IdentityNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IdentityNo;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BirthDate;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsVerification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVerification;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The BirthDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthDateString;
    /**
     * The IdentitySerialNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdentitySerialNo;
    /**
     * The CreateUserIp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateUserIp;
    /**
     * Constructor method for AccountIdentityEntity
     * @uses AccountIdentityEntity::setId()
     * @uses AccountIdentityEntity::setAccountId()
     * @uses AccountIdentityEntity::setIdentityNo()
     * @uses AccountIdentityEntity::setBirthDate()
     * @uses AccountIdentityEntity::setCreateDate()
     * @uses AccountIdentityEntity::setIsVerification()
     * @uses AccountIdentityEntity::setIsDeleted()
     * @uses AccountIdentityEntity::setBirthDateString()
     * @uses AccountIdentityEntity::setIdentitySerialNo()
     * @uses AccountIdentityEntity::setCreateUserIp()
     * @param int $id
     * @param int $accountId
     * @param int $identityNo
     * @param string $birthDate
     * @param string $createDate
     * @param bool $isVerification
     * @param bool $isDeleted
     * @param string $birthDateString
     * @param string $identitySerialNo
     * @param string $createUserIp
     */
    public function __construct($id = null, $accountId = null, $identityNo = null, $birthDate = null, $createDate = null, $isVerification = null, $isDeleted = null, $birthDateString = null, $identitySerialNo = null, $createUserIp = null)
    {
        $this
            ->setId($id)
            ->setAccountId($accountId)
            ->setIdentityNo($identityNo)
            ->setBirthDate($birthDate)
            ->setCreateDate($createDate)
            ->setIsVerification($isVerification)
            ->setIsDeleted($isDeleted)
            ->setBirthDateString($birthDateString)
            ->setIdentitySerialNo($identitySerialNo)
            ->setCreateUserIp($createUserIp);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\AccountIdentityEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\AccountIdentityEntity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get IdentityNo value
     * @return int
     */
    public function getIdentityNo()
    {
        return $this->IdentityNo;
    }
    /**
     * Set IdentityNo value
     * @param int $identityNo
     * @return \StructType\AccountIdentityEntity
     */
    public function setIdentityNo($identityNo = null)
    {
        // validation for constraint: int
        if (!is_null($identityNo) && !(is_int($identityNo) || ctype_digit($identityNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identityNo, true), gettype($identityNo)), __LINE__);
        }
        $this->IdentityNo = $identityNo;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\AccountIdentityEntity
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\AccountIdentityEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsVerification value
     * @return bool
     */
    public function getIsVerification()
    {
        return $this->IsVerification;
    }
    /**
     * Set IsVerification value
     * @param bool $isVerification
     * @return \StructType\AccountIdentityEntity
     */
    public function setIsVerification($isVerification = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerification) && !is_bool($isVerification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerification, true), gettype($isVerification)), __LINE__);
        }
        $this->IsVerification = $isVerification;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\AccountIdentityEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get BirthDateString value
     * @return string|null
     */
    public function getBirthDateString()
    {
        return $this->BirthDateString;
    }
    /**
     * Set BirthDateString value
     * @param string $birthDateString
     * @return \StructType\AccountIdentityEntity
     */
    public function setBirthDateString($birthDateString = null)
    {
        // validation for constraint: string
        if (!is_null($birthDateString) && !is_string($birthDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDateString, true), gettype($birthDateString)), __LINE__);
        }
        $this->BirthDateString = $birthDateString;
        return $this;
    }
    /**
     * Get IdentitySerialNo value
     * @return string|null
     */
    public function getIdentitySerialNo()
    {
        return $this->IdentitySerialNo;
    }
    /**
     * Set IdentitySerialNo value
     * @param string $identitySerialNo
     * @return \StructType\AccountIdentityEntity
     */
    public function setIdentitySerialNo($identitySerialNo = null)
    {
        // validation for constraint: string
        if (!is_null($identitySerialNo) && !is_string($identitySerialNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identitySerialNo, true), gettype($identitySerialNo)), __LINE__);
        }
        $this->IdentitySerialNo = $identitySerialNo;
        return $this;
    }
    /**
     * Get CreateUserIp value
     * @return string|null
     */
    public function getCreateUserIp()
    {
        return $this->CreateUserIp;
    }
    /**
     * Set CreateUserIp value
     * @param string $createUserIp
     * @return \StructType\AccountIdentityEntity
     */
    public function setCreateUserIp($createUserIp = null)
    {
        // validation for constraint: string
        if (!is_null($createUserIp) && !is_string($createUserIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserIp, true), gettype($createUserIp)), __LINE__);
        }
        $this->CreateUserIp = $createUserIp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountIdentityEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
