<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountCreditCardsEntity StructType
 * @subpackage Structs
 */
class AccountCreditCardsEntity extends AbstractStructBase
{
    /**
     * The BankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankId;
    /**
     * The cardToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardToken;
    /**
     * The cardOwner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardOwner;
    /**
     * The panLast4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $panLast4;
    /**
     * The cardBin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardBin;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer;
    /**
     * The cardbrand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardbrand;
    /**
     * The cardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardType;
    /**
     * The cardLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardLevel;
    /**
     * The cardNetwork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardNetwork;
    /**
     * The cardIssuer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardIssuer;
    /**
     * The cardVirtual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardVirtual;
    /**
     * The cardCountryIso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardCountryIso;
    /**
     * The cardPaymentSystem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardPaymentSystem;
    /**
     * The cardExpiry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardExpiry;
    /**
     * The cardName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardName;
    /**
     * The pan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pan;
    /**
     * The ExpiryMonth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryMonth;
    /**
     * The ExpiryYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryYear;
    /**
     * The Ccv
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ccv;
    /**
     * The Bank
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BanksEntity
     */
    public $Bank;
    /**
     * The CreditCartImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCartImageUrl;
    /**
     * Constructor method for AccountCreditCardsEntity
     * @uses AccountCreditCardsEntity::setBankId()
     * @uses AccountCreditCardsEntity::setCardToken()
     * @uses AccountCreditCardsEntity::setCardOwner()
     * @uses AccountCreditCardsEntity::setPanLast4()
     * @uses AccountCreditCardsEntity::setCardBin()
     * @uses AccountCreditCardsEntity::setCustomer()
     * @uses AccountCreditCardsEntity::setCardbrand()
     * @uses AccountCreditCardsEntity::setCardType()
     * @uses AccountCreditCardsEntity::setCardLevel()
     * @uses AccountCreditCardsEntity::setCardNetwork()
     * @uses AccountCreditCardsEntity::setCardIssuer()
     * @uses AccountCreditCardsEntity::setCardVirtual()
     * @uses AccountCreditCardsEntity::setCardCountryIso()
     * @uses AccountCreditCardsEntity::setCardPaymentSystem()
     * @uses AccountCreditCardsEntity::setCardExpiry()
     * @uses AccountCreditCardsEntity::setCardName()
     * @uses AccountCreditCardsEntity::setPan()
     * @uses AccountCreditCardsEntity::setExpiryMonth()
     * @uses AccountCreditCardsEntity::setExpiryYear()
     * @uses AccountCreditCardsEntity::setCcv()
     * @uses AccountCreditCardsEntity::setBank()
     * @uses AccountCreditCardsEntity::setCreditCartImageUrl()
     * @param int $bankId
     * @param string $cardToken
     * @param string $cardOwner
     * @param string $panLast4
     * @param string $cardBin
     * @param string $customer
     * @param string $cardbrand
     * @param string $cardType
     * @param string $cardLevel
     * @param string $cardNetwork
     * @param string $cardIssuer
     * @param string $cardVirtual
     * @param string $cardCountryIso
     * @param string $cardPaymentSystem
     * @param string $cardExpiry
     * @param string $cardName
     * @param string $pan
     * @param string $expiryMonth
     * @param string $expiryYear
     * @param string $ccv
     * @param \StructType\BanksEntity $bank
     * @param string $creditCartImageUrl
     */
    public function __construct($bankId = null, $cardToken = null, $cardOwner = null, $panLast4 = null, $cardBin = null, $customer = null, $cardbrand = null, $cardType = null, $cardLevel = null, $cardNetwork = null, $cardIssuer = null, $cardVirtual = null, $cardCountryIso = null, $cardPaymentSystem = null, $cardExpiry = null, $cardName = null, $pan = null, $expiryMonth = null, $expiryYear = null, $ccv = null, \StructType\BanksEntity $bank = null, $creditCartImageUrl = null)
    {
        $this
            ->setBankId($bankId)
            ->setCardToken($cardToken)
            ->setCardOwner($cardOwner)
            ->setPanLast4($panLast4)
            ->setCardBin($cardBin)
            ->setCustomer($customer)
            ->setCardbrand($cardbrand)
            ->setCardType($cardType)
            ->setCardLevel($cardLevel)
            ->setCardNetwork($cardNetwork)
            ->setCardIssuer($cardIssuer)
            ->setCardVirtual($cardVirtual)
            ->setCardCountryIso($cardCountryIso)
            ->setCardPaymentSystem($cardPaymentSystem)
            ->setCardExpiry($cardExpiry)
            ->setCardName($cardName)
            ->setPan($pan)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setCcv($ccv)
            ->setBank($bank)
            ->setCreditCartImageUrl($creditCartImageUrl);
    }
    /**
     * Get BankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->BankId;
    }
    /**
     * Set BankId value
     * @param int $bankId
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->BankId = $bankId;
        return $this;
    }
    /**
     * Get cardToken value
     * @return string|null
     */
    public function getCardToken()
    {
        return $this->cardToken;
    }
    /**
     * Set cardToken value
     * @param string $cardToken
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardToken($cardToken = null)
    {
        // validation for constraint: string
        if (!is_null($cardToken) && !is_string($cardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardToken, true), gettype($cardToken)), __LINE__);
        }
        $this->cardToken = $cardToken;
        return $this;
    }
    /**
     * Get cardOwner value
     * @return string|null
     */
    public function getCardOwner()
    {
        return $this->cardOwner;
    }
    /**
     * Set cardOwner value
     * @param string $cardOwner
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardOwner($cardOwner = null)
    {
        // validation for constraint: string
        if (!is_null($cardOwner) && !is_string($cardOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardOwner, true), gettype($cardOwner)), __LINE__);
        }
        $this->cardOwner = $cardOwner;
        return $this;
    }
    /**
     * Get panLast4 value
     * @return string|null
     */
    public function getPanLast4()
    {
        return $this->panLast4;
    }
    /**
     * Set panLast4 value
     * @param string $panLast4
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setPanLast4($panLast4 = null)
    {
        // validation for constraint: string
        if (!is_null($panLast4) && !is_string($panLast4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panLast4, true), gettype($panLast4)), __LINE__);
        }
        $this->panLast4 = $panLast4;
        return $this;
    }
    /**
     * Get cardBin value
     * @return string|null
     */
    public function getCardBin()
    {
        return $this->cardBin;
    }
    /**
     * Set cardBin value
     * @param string $cardBin
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardBin($cardBin = null)
    {
        // validation for constraint: string
        if (!is_null($cardBin) && !is_string($cardBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardBin, true), gettype($cardBin)), __LINE__);
        }
        $this->cardBin = $cardBin;
        return $this;
    }
    /**
     * Get customer value
     * @return string|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param string $customer
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: string
        if (!is_null($customer) && !is_string($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer, true), gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get cardbrand value
     * @return string|null
     */
    public function getCardbrand()
    {
        return $this->cardbrand;
    }
    /**
     * Set cardbrand value
     * @param string $cardbrand
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardbrand($cardbrand = null)
    {
        // validation for constraint: string
        if (!is_null($cardbrand) && !is_string($cardbrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardbrand, true), gettype($cardbrand)), __LINE__);
        }
        $this->cardbrand = $cardbrand;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardLevel value
     * @return string|null
     */
    public function getCardLevel()
    {
        return $this->cardLevel;
    }
    /**
     * Set cardLevel value
     * @param string $cardLevel
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardLevel($cardLevel = null)
    {
        // validation for constraint: string
        if (!is_null($cardLevel) && !is_string($cardLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardLevel, true), gettype($cardLevel)), __LINE__);
        }
        $this->cardLevel = $cardLevel;
        return $this;
    }
    /**
     * Get cardNetwork value
     * @return string|null
     */
    public function getCardNetwork()
    {
        return $this->cardNetwork;
    }
    /**
     * Set cardNetwork value
     * @param string $cardNetwork
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardNetwork($cardNetwork = null)
    {
        // validation for constraint: string
        if (!is_null($cardNetwork) && !is_string($cardNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNetwork, true), gettype($cardNetwork)), __LINE__);
        }
        $this->cardNetwork = $cardNetwork;
        return $this;
    }
    /**
     * Get cardIssuer value
     * @return string|null
     */
    public function getCardIssuer()
    {
        return $this->cardIssuer;
    }
    /**
     * Set cardIssuer value
     * @param string $cardIssuer
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardIssuer($cardIssuer = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssuer) && !is_string($cardIssuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssuer, true), gettype($cardIssuer)), __LINE__);
        }
        $this->cardIssuer = $cardIssuer;
        return $this;
    }
    /**
     * Get cardVirtual value
     * @return string|null
     */
    public function getCardVirtual()
    {
        return $this->cardVirtual;
    }
    /**
     * Set cardVirtual value
     * @param string $cardVirtual
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardVirtual($cardVirtual = null)
    {
        // validation for constraint: string
        if (!is_null($cardVirtual) && !is_string($cardVirtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardVirtual, true), gettype($cardVirtual)), __LINE__);
        }
        $this->cardVirtual = $cardVirtual;
        return $this;
    }
    /**
     * Get cardCountryIso value
     * @return string|null
     */
    public function getCardCountryIso()
    {
        return $this->cardCountryIso;
    }
    /**
     * Set cardCountryIso value
     * @param string $cardCountryIso
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardCountryIso($cardCountryIso = null)
    {
        // validation for constraint: string
        if (!is_null($cardCountryIso) && !is_string($cardCountryIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCountryIso, true), gettype($cardCountryIso)), __LINE__);
        }
        $this->cardCountryIso = $cardCountryIso;
        return $this;
    }
    /**
     * Get cardPaymentSystem value
     * @return string|null
     */
    public function getCardPaymentSystem()
    {
        return $this->cardPaymentSystem;
    }
    /**
     * Set cardPaymentSystem value
     * @param string $cardPaymentSystem
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardPaymentSystem($cardPaymentSystem = null)
    {
        // validation for constraint: string
        if (!is_null($cardPaymentSystem) && !is_string($cardPaymentSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardPaymentSystem, true), gettype($cardPaymentSystem)), __LINE__);
        }
        $this->cardPaymentSystem = $cardPaymentSystem;
        return $this;
    }
    /**
     * Get cardExpiry value
     * @return string|null
     */
    public function getCardExpiry()
    {
        return $this->cardExpiry;
    }
    /**
     * Set cardExpiry value
     * @param string $cardExpiry
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardExpiry($cardExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiry) && !is_string($cardExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiry, true), gettype($cardExpiry)), __LINE__);
        }
        $this->cardExpiry = $cardExpiry;
        return $this;
    }
    /**
     * Get cardName value
     * @return string|null
     */
    public function getCardName()
    {
        return $this->cardName;
    }
    /**
     * Set cardName value
     * @param string $cardName
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardName, true), gettype($cardName)), __LINE__);
        }
        $this->cardName = $cardName;
        return $this;
    }
    /**
     * Get pan value
     * @return string|null
     */
    public function getPan()
    {
        return $this->pan;
    }
    /**
     * Set pan value
     * @param string $pan
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setPan($pan = null)
    {
        // validation for constraint: string
        if (!is_null($pan) && !is_string($pan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pan, true), gettype($pan)), __LINE__);
        }
        $this->pan = $pan;
        return $this;
    }
    /**
     * Get ExpiryMonth value
     * @return string|null
     */
    public function getExpiryMonth()
    {
        return $this->ExpiryMonth;
    }
    /**
     * Set ExpiryMonth value
     * @param string $expiryMonth
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        // validation for constraint: string
        if (!is_null($expiryMonth) && !is_string($expiryMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryMonth, true), gettype($expiryMonth)), __LINE__);
        }
        $this->ExpiryMonth = $expiryMonth;
        return $this;
    }
    /**
     * Get ExpiryYear value
     * @return string|null
     */
    public function getExpiryYear()
    {
        return $this->ExpiryYear;
    }
    /**
     * Set ExpiryYear value
     * @param string $expiryYear
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setExpiryYear($expiryYear = null)
    {
        // validation for constraint: string
        if (!is_null($expiryYear) && !is_string($expiryYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryYear, true), gettype($expiryYear)), __LINE__);
        }
        $this->ExpiryYear = $expiryYear;
        return $this;
    }
    /**
     * Get Ccv value
     * @return string|null
     */
    public function getCcv()
    {
        return $this->Ccv;
    }
    /**
     * Set Ccv value
     * @param string $ccv
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCcv($ccv = null)
    {
        // validation for constraint: string
        if (!is_null($ccv) && !is_string($ccv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccv, true), gettype($ccv)), __LINE__);
        }
        $this->Ccv = $ccv;
        return $this;
    }
    /**
     * Get Bank value
     * @return \StructType\BanksEntity|null
     */
    public function getBank()
    {
        return $this->Bank;
    }
    /**
     * Set Bank value
     * @param \StructType\BanksEntity $bank
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setBank(\StructType\BanksEntity $bank = null)
    {
        $this->Bank = $bank;
        return $this;
    }
    /**
     * Get CreditCartImageUrl value
     * @return string|null
     */
    public function getCreditCartImageUrl()
    {
        return $this->CreditCartImageUrl;
    }
    /**
     * Set CreditCartImageUrl value
     * @param string $creditCartImageUrl
     * @return \StructType\AccountCreditCardsEntity
     */
    public function setCreditCartImageUrl($creditCartImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($creditCartImageUrl) && !is_string($creditCartImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCartImageUrl, true), gettype($creditCartImageUrl)), __LINE__);
        }
        $this->CreditCartImageUrl = $creditCartImageUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountCreditCardsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
