<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Shopping ServiceType
 * @subpackage Services
 */
class Shopping extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ShoppingQrCodeConvert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingQrCodeConvert $parameters
     * @return \StructType\ShoppingQrCodeConvertResponse|bool
     */
    public function ShoppingQrCodeConvert(\StructType\ShoppingQrCodeConvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingQrCodeConvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingAddtoCartforQrCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingAddtoCartforQrCode $parameters
     * @return \StructType\ShoppingAddtoCartforQrCodeResponse|bool
     */
    public function ShoppingAddtoCartforQrCode(\StructType\ShoppingAddtoCartforQrCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingAddtoCartforQrCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingAddtoCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingAddtoCart $parameters
     * @return \StructType\ShoppingAddtoCartResponse|bool
     */
    public function ShoppingAddtoCart(\StructType\ShoppingAddtoCart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingAddtoCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingGetCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingGetCart $parameters
     * @return \StructType\ShoppingGetCartResponse|bool
     */
    public function ShoppingGetCart(\StructType\ShoppingGetCart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingGetCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingDeleteProducttoCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingDeleteProducttoCart $parameters
     * @return \StructType\ShoppingDeleteProducttoCartResponse|bool
     */
    public function ShoppingDeleteProducttoCart(\StructType\ShoppingDeleteProducttoCart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingDeleteProducttoCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingCartAmount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingCartAmount $parameters
     * @return \StructType\ShoppingCartAmountResponse|bool
     */
    public function ShoppingCartAmount(\StructType\ShoppingCartAmount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingCartAmount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingAddNewAdress
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingAddNewAdress $parameters
     * @return \StructType\ShoppingAddNewAdressResponse|bool
     */
    public function ShoppingAddNewAdress(\StructType\ShoppingAddNewAdress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingAddNewAdress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingGetAdressList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingGetAdressList $parameters
     * @return \StructType\ShoppingGetAdressListResponse|bool
     */
    public function ShoppingGetAdressList(\StructType\ShoppingGetAdressList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingGetAdressList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingGetAllAdressList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingGetAllAdressList $parameters
     * @return \StructType\ShoppingGetAllAdressListResponse|bool
     */
    public function ShoppingGetAllAdressList(\StructType\ShoppingGetAllAdressList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingGetAllAdressList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingGetAdressDetail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingGetAdressDetail $parameters
     * @return \StructType\ShoppingGetAdressDetailResponse|bool
     */
    public function ShoppingGetAdressDetail(\StructType\ShoppingGetAdressDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingGetAdressDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingAdressUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingAdressUpdate $parameters
     * @return \StructType\ShoppingAdressUpdateResponse|bool
     */
    public function ShoppingAdressUpdate(\StructType\ShoppingAdressUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingAdressUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingAdressDelete
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingAdressDelete $parameters
     * @return \StructType\ShoppingAdressDeleteResponse|bool
     */
    public function ShoppingAdressDelete(\StructType\ShoppingAdressDelete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingAdressDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingPaywithWalletCodeforCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingPaywithWalletCodeforCart $parameters
     * @return \StructType\ShoppingPaywithWalletCodeforCartResponse|bool
     */
    public function ShoppingPaywithWalletCodeforCart(\StructType\ShoppingPaywithWalletCodeforCart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingPaywithWalletCodeforCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ShoppingPaywithWalletCodeforAddition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingPaywithWalletCodeforAddition $parameters
     * @return \StructType\ShoppingPaywithWalletCodeforAdditionResponse|bool
     */
    public function ShoppingPaywithWalletCodeforAddition(\StructType\ShoppingPaywithWalletCodeforAddition $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingPaywithWalletCodeforAddition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingPaywithWalletCodeforJson
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingPaywithWalletCodeforJson $parameters
     * @return \StructType\ShoppingPaywithWalletCodeforJsonResponse|bool
     */
    public function ShoppingPaywithWalletCodeforJson(\StructType\ShoppingPaywithWalletCodeforJson $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingPaywithWalletCodeforJson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ShoppingPaywithCreditCartCodeforCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingPaywithCreditCartCodeforCart $parameters
     * @return \StructType\ShoppingPaywithCreditCartCodeforCartResponse|bool
     */
    public function ShoppingPaywithCreditCartCodeforCart(\StructType\ShoppingPaywithCreditCartCodeforCart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingPaywithCreditCartCodeforCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ShoppingPaywithCreditCartCodeforAddition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingPaywithCreditCartCodeforAddition $parameters
     * @return \StructType\ShoppingPaywithCreditCartCodeforAdditionResponse|bool
     */
    public function ShoppingPaywithCreditCartCodeforAddition(\StructType\ShoppingPaywithCreditCartCodeforAddition $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingPaywithCreditCartCodeforAddition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ShoppingPaywithCreditCartCodeforJson
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingPaywithCreditCartCodeforJson $parameters
     * @return \StructType\ShoppingPaywithCreditCartCodeforJsonResponse|bool
     */
    public function ShoppingPaywithCreditCartCodeforJson(\StructType\ShoppingPaywithCreditCartCodeforJson $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingPaywithCreditCartCodeforJson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShoppingAddNewAdressResponse|\StructType\ShoppingAddtoCartforQrCodeResponse|\StructType\ShoppingAddtoCartResponse|\StructType\ShoppingAdressDeleteResponse|\StructType\ShoppingAdressUpdateResponse|\StructType\ShoppingCartAmountResponse|\StructType\ShoppingDeleteProducttoCartResponse|\StructType\ShoppingGetAdressDetailResponse|\StructType\ShoppingGetAdressListResponse|\StructType\ShoppingGetAllAdressListResponse|\StructType\ShoppingGetCartResponse|\StructType\ShoppingPaywithCreditCartCodeforAdditionResponse|\StructType\ShoppingPaywithCreditCartCodeforCartResponse|\StructType\ShoppingPaywithCreditCartCodeforJsonResponse|\StructType\ShoppingPaywithWalletCodeforAdditionResponse|\StructType\ShoppingPaywithWalletCodeforCartResponse|\StructType\ShoppingPaywithWalletCodeforJsonResponse|\StructType\ShoppingQrCodeConvertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
