<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named LoadMoneywithBankTransferControl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneywithBankTransferControl $parameters
     * @return \StructType\LoadMoneywithBankTransferControlResponse|bool
     */
    public function LoadMoneywithBankTransferControl(\StructType\LoadMoneywithBankTransferControl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneywithBankTransferControl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMoneywithBankTransfer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneywithBankTransfer $parameters
     * @return \StructType\LoadMoneywithBankTransferResponse|bool
     */
    public function LoadMoneywithBankTransfer(\StructType\LoadMoneywithBankTransfer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneywithBankTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMoneywithATMTransferControl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneywithATMTransferControl $parameters
     * @return \StructType\LoadMoneywithATMTransferControlResponse|bool
     */
    public function LoadMoneywithATMTransferControl(\StructType\LoadMoneywithATMTransferControl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneywithATMTransferControl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMoneywithATMTransfer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneywithATMTransfer $parameters
     * @return \StructType\LoadMoneywithATMTransferResponse|bool
     */
    public function LoadMoneywithATMTransfer(\StructType\LoadMoneywithATMTransfer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneywithATMTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMoneywithBranchTransferControl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneywithBranchTransferControl $parameters
     * @return \StructType\LoadMoneywithBranchTransferControlResponse|bool
     */
    public function LoadMoneywithBranchTransferControl(\StructType\LoadMoneywithBranchTransferControl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneywithBranchTransferControl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMoneywithBranchTransfer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneywithBranchTransfer $parameters
     * @return \StructType\LoadMoneywithBranchTransferResponse|bool
     */
    public function LoadMoneywithBranchTransfer(\StructType\LoadMoneywithBranchTransfer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneywithBranchTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMoneyRequestCancel
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMoneyRequestCancel $parameters
     * @return \StructType\LoadMoneyRequestCancelResponse|bool
     */
    public function LoadMoneyRequestCancel(\StructType\LoadMoneyRequestCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMoneyRequestCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoadMoneyRequestCancelResponse|\StructType\LoadMoneywithATMTransferControlResponse|\StructType\LoadMoneywithATMTransferResponse|\StructType\LoadMoneywithBankTransferControlResponse|\StructType\LoadMoneywithBankTransferResponse|\StructType\LoadMoneywithBranchTransferControlResponse|\StructType\LoadMoneywithBranchTransferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
