<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Decyrpt ServiceType
 * @subpackage Services
 */
class Decyrpt extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DecyrptData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DecyrptData $parameters
     * @return \StructType\DecyrptDataResponse|bool
     */
    public function DecyrptData(\StructType\DecyrptData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DecyrptData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DecyrptDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
