<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWalletsEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfWalletsEntity extends AbstractStructArrayBase
{
    /**
     * The WalletsEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WalletsEntity[]
     */
    public $WalletsEntity;
    /**
     * Constructor method for ArrayOfWalletsEntity
     * @uses ArrayOfWalletsEntity::setWalletsEntity()
     * @param \StructType\WalletsEntity[] $walletsEntity
     */
    public function __construct(array $walletsEntity = array())
    {
        $this
            ->setWalletsEntity($walletsEntity);
    }
    /**
     * Get WalletsEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WalletsEntity[]|null
     */
    public function getWalletsEntity()
    {
        return isset($this->WalletsEntity) ? $this->WalletsEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWalletsEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWalletsEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWalletsEntityForArrayConstraintsFromSetWalletsEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWalletsEntityWalletsEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfWalletsEntityWalletsEntityItem instanceof \StructType\WalletsEntity) {
                $invalidValues[] = is_object($arrayOfWalletsEntityWalletsEntityItem) ? get_class($arrayOfWalletsEntityWalletsEntityItem) : sprintf('%s(%s)', gettype($arrayOfWalletsEntityWalletsEntityItem), var_export($arrayOfWalletsEntityWalletsEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WalletsEntity property can only contain items of type \StructType\WalletsEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WalletsEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WalletsEntity[] $walletsEntity
     * @return \ArrayType\ArrayOfWalletsEntity
     */
    public function setWalletsEntity(array $walletsEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($walletsEntityArrayErrorMessage = self::validateWalletsEntityForArrayConstraintsFromSetWalletsEntity($walletsEntity))) {
            throw new \InvalidArgumentException($walletsEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($walletsEntity) || (is_array($walletsEntity) && empty($walletsEntity))) {
            unset($this->WalletsEntity);
        } else {
            $this->WalletsEntity = $walletsEntity;
        }
        return $this;
    }
    /**
     * Add item to WalletsEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\WalletsEntity $item
     * @return \ArrayType\ArrayOfWalletsEntity
     */
    public function addToWalletsEntity(\StructType\WalletsEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WalletsEntity) {
            throw new \InvalidArgumentException(sprintf('The WalletsEntity property can only contain items of type \StructType\WalletsEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WalletsEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WalletsEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WalletsEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WalletsEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WalletsEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WalletsEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WalletsEntity
     */
    public function getAttributeName()
    {
        return 'WalletsEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWalletsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
