<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShoppingTypeEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfShoppingTypeEntity extends AbstractStructArrayBase
{
    /**
     * The ShoppingTypeEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShoppingTypeEntity[]
     */
    public $ShoppingTypeEntity;
    /**
     * Constructor method for ArrayOfShoppingTypeEntity
     * @uses ArrayOfShoppingTypeEntity::setShoppingTypeEntity()
     * @param \StructType\ShoppingTypeEntity[] $shoppingTypeEntity
     */
    public function __construct(array $shoppingTypeEntity = array())
    {
        $this
            ->setShoppingTypeEntity($shoppingTypeEntity);
    }
    /**
     * Get ShoppingTypeEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShoppingTypeEntity[]|null
     */
    public function getShoppingTypeEntity()
    {
        return isset($this->ShoppingTypeEntity) ? $this->ShoppingTypeEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShoppingTypeEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShoppingTypeEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShoppingTypeEntityForArrayConstraintsFromSetShoppingTypeEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShoppingTypeEntityShoppingTypeEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfShoppingTypeEntityShoppingTypeEntityItem instanceof \StructType\ShoppingTypeEntity) {
                $invalidValues[] = is_object($arrayOfShoppingTypeEntityShoppingTypeEntityItem) ? get_class($arrayOfShoppingTypeEntityShoppingTypeEntityItem) : sprintf('%s(%s)', gettype($arrayOfShoppingTypeEntityShoppingTypeEntityItem), var_export($arrayOfShoppingTypeEntityShoppingTypeEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShoppingTypeEntity property can only contain items of type \StructType\ShoppingTypeEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShoppingTypeEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingTypeEntity[] $shoppingTypeEntity
     * @return \ArrayType\ArrayOfShoppingTypeEntity
     */
    public function setShoppingTypeEntity(array $shoppingTypeEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($shoppingTypeEntityArrayErrorMessage = self::validateShoppingTypeEntityForArrayConstraintsFromSetShoppingTypeEntity($shoppingTypeEntity))) {
            throw new \InvalidArgumentException($shoppingTypeEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($shoppingTypeEntity) || (is_array($shoppingTypeEntity) && empty($shoppingTypeEntity))) {
            unset($this->ShoppingTypeEntity);
        } else {
            $this->ShoppingTypeEntity = $shoppingTypeEntity;
        }
        return $this;
    }
    /**
     * Add item to ShoppingTypeEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingTypeEntity $item
     * @return \ArrayType\ArrayOfShoppingTypeEntity
     */
    public function addToShoppingTypeEntity(\StructType\ShoppingTypeEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingTypeEntity) {
            throw new \InvalidArgumentException(sprintf('The ShoppingTypeEntity property can only contain items of type \StructType\ShoppingTypeEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShoppingTypeEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShoppingTypeEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShoppingTypeEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShoppingTypeEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShoppingTypeEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShoppingTypeEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShoppingTypeEntity
     */
    public function getAttributeName()
    {
        return 'ShoppingTypeEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShoppingTypeEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
