<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShoppingCartEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfShoppingCartEntity extends AbstractStructArrayBase
{
    /**
     * The ShoppingCartEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShoppingCartEntity[]
     */
    public $ShoppingCartEntity;
    /**
     * Constructor method for ArrayOfShoppingCartEntity
     * @uses ArrayOfShoppingCartEntity::setShoppingCartEntity()
     * @param \StructType\ShoppingCartEntity[] $shoppingCartEntity
     */
    public function __construct(array $shoppingCartEntity = array())
    {
        $this
            ->setShoppingCartEntity($shoppingCartEntity);
    }
    /**
     * Get ShoppingCartEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShoppingCartEntity[]|null
     */
    public function getShoppingCartEntity()
    {
        return isset($this->ShoppingCartEntity) ? $this->ShoppingCartEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShoppingCartEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShoppingCartEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShoppingCartEntityForArrayConstraintsFromSetShoppingCartEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShoppingCartEntityShoppingCartEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfShoppingCartEntityShoppingCartEntityItem instanceof \StructType\ShoppingCartEntity) {
                $invalidValues[] = is_object($arrayOfShoppingCartEntityShoppingCartEntityItem) ? get_class($arrayOfShoppingCartEntityShoppingCartEntityItem) : sprintf('%s(%s)', gettype($arrayOfShoppingCartEntityShoppingCartEntityItem), var_export($arrayOfShoppingCartEntityShoppingCartEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShoppingCartEntity property can only contain items of type \StructType\ShoppingCartEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShoppingCartEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingCartEntity[] $shoppingCartEntity
     * @return \ArrayType\ArrayOfShoppingCartEntity
     */
    public function setShoppingCartEntity(array $shoppingCartEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($shoppingCartEntityArrayErrorMessage = self::validateShoppingCartEntityForArrayConstraintsFromSetShoppingCartEntity($shoppingCartEntity))) {
            throw new \InvalidArgumentException($shoppingCartEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($shoppingCartEntity) || (is_array($shoppingCartEntity) && empty($shoppingCartEntity))) {
            unset($this->ShoppingCartEntity);
        } else {
            $this->ShoppingCartEntity = $shoppingCartEntity;
        }
        return $this;
    }
    /**
     * Add item to ShoppingCartEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingCartEntity $item
     * @return \ArrayType\ArrayOfShoppingCartEntity
     */
    public function addToShoppingCartEntity(\StructType\ShoppingCartEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingCartEntity) {
            throw new \InvalidArgumentException(sprintf('The ShoppingCartEntity property can only contain items of type \StructType\ShoppingCartEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShoppingCartEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShoppingCartEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShoppingCartEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShoppingCartEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShoppingCartEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShoppingCartEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShoppingCartEntity
     */
    public function getAttributeName()
    {
        return 'ShoppingCartEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShoppingCartEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
