<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInstitutionsListEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfInstitutionsListEntity extends AbstractStructArrayBase
{
    /**
     * The InstitutionsListEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InstitutionsListEntity[]
     */
    public $InstitutionsListEntity;
    /**
     * Constructor method for ArrayOfInstitutionsListEntity
     * @uses ArrayOfInstitutionsListEntity::setInstitutionsListEntity()
     * @param \StructType\InstitutionsListEntity[] $institutionsListEntity
     */
    public function __construct(array $institutionsListEntity = array())
    {
        $this
            ->setInstitutionsListEntity($institutionsListEntity);
    }
    /**
     * Get InstitutionsListEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InstitutionsListEntity[]|null
     */
    public function getInstitutionsListEntity()
    {
        return isset($this->InstitutionsListEntity) ? $this->InstitutionsListEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInstitutionsListEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstitutionsListEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstitutionsListEntityForArrayConstraintsFromSetInstitutionsListEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInstitutionsListEntityInstitutionsListEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfInstitutionsListEntityInstitutionsListEntityItem instanceof \StructType\InstitutionsListEntity) {
                $invalidValues[] = is_object($arrayOfInstitutionsListEntityInstitutionsListEntityItem) ? get_class($arrayOfInstitutionsListEntityInstitutionsListEntityItem) : sprintf('%s(%s)', gettype($arrayOfInstitutionsListEntityInstitutionsListEntityItem), var_export($arrayOfInstitutionsListEntityInstitutionsListEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InstitutionsListEntity property can only contain items of type \StructType\InstitutionsListEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InstitutionsListEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InstitutionsListEntity[] $institutionsListEntity
     * @return \ArrayType\ArrayOfInstitutionsListEntity
     */
    public function setInstitutionsListEntity(array $institutionsListEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($institutionsListEntityArrayErrorMessage = self::validateInstitutionsListEntityForArrayConstraintsFromSetInstitutionsListEntity($institutionsListEntity))) {
            throw new \InvalidArgumentException($institutionsListEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($institutionsListEntity) || (is_array($institutionsListEntity) && empty($institutionsListEntity))) {
            unset($this->InstitutionsListEntity);
        } else {
            $this->InstitutionsListEntity = $institutionsListEntity;
        }
        return $this;
    }
    /**
     * Add item to InstitutionsListEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\InstitutionsListEntity $item
     * @return \ArrayType\ArrayOfInstitutionsListEntity
     */
    public function addToInstitutionsListEntity(\StructType\InstitutionsListEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InstitutionsListEntity) {
            throw new \InvalidArgumentException(sprintf('The InstitutionsListEntity property can only contain items of type \StructType\InstitutionsListEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InstitutionsListEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InstitutionsListEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InstitutionsListEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InstitutionsListEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InstitutionsListEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InstitutionsListEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InstitutionsListEntity
     */
    public function getAttributeName()
    {
        return 'InstitutionsListEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInstitutionsListEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
