<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillList ArrayType
 * @subpackage Arrays
 */
class ArrayOfBillList extends AbstractStructArrayBase
{
    /**
     * The BillList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillList[]
     */
    public $BillList;
    /**
     * Constructor method for ArrayOfBillList
     * @uses ArrayOfBillList::setBillList()
     * @param \StructType\BillList[] $billList
     */
    public function __construct(array $billList = array())
    {
        $this
            ->setBillList($billList);
    }
    /**
     * Get BillList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillList[]|null
     */
    public function getBillList()
    {
        return isset($this->BillList) ? $this->BillList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBillList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillListForArrayConstraintsFromSetBillList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBillListBillListItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillListBillListItem instanceof \StructType\BillList) {
                $invalidValues[] = is_object($arrayOfBillListBillListItem) ? get_class($arrayOfBillListBillListItem) : sprintf('%s(%s)', gettype($arrayOfBillListBillListItem), var_export($arrayOfBillListBillListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillList property can only contain items of type \StructType\BillList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BillList[] $billList
     * @return \ArrayType\ArrayOfBillList
     */
    public function setBillList(array $billList = array())
    {
        // validation for constraint: array
        if ('' !== ($billListArrayErrorMessage = self::validateBillListForArrayConstraintsFromSetBillList($billList))) {
            throw new \InvalidArgumentException($billListArrayErrorMessage, __LINE__);
        }
        if (is_null($billList) || (is_array($billList) && empty($billList))) {
            unset($this->BillList);
        } else {
            $this->BillList = $billList;
        }
        return $this;
    }
    /**
     * Add item to BillList value
     * @throws \InvalidArgumentException
     * @param \StructType\BillList $item
     * @return \ArrayType\ArrayOfBillList
     */
    public function addToBillList(\StructType\BillList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BillList) {
            throw new \InvalidArgumentException(sprintf('The BillList property can only contain items of type \StructType\BillList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BillList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BillList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BillList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BillList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BillList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillList
     */
    public function getAttributeName()
    {
        return 'BillList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBillList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
