<?php

namespace App\Helpers\Airline\SereneAir\Requests\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidateSecurityToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Helpers\Airline\SereneAir\Requests\StructType\ValidateSecurityToken $parameters
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\ValidateSecurityTokenResponse|bool
     */
    public function ValidateSecurityToken(\App\Helpers\Airline\SereneAir\Requests\StructType\ValidateSecurityToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateSecurityToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\ValidateSecurityTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
