<?php

namespace App\Helpers\Airline\SereneAir\Requests\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupData
 * @subpackage Structs
 */
class GroupData extends AbstractStructBase
{
    /**
     * The GroupDataId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GroupDataId;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IsActive;
    /**
     * The UseAirportSecurity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UseAirportSecurity;
    /**
     * The UseResChannelSecurity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UseResChannelSecurity;
    /**
     * The Airports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataAirport
     */
    public $Airports;
    /**
     * The ReservationChannels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataResChannel
     */
    public $ReservationChannels;
    /**
     * Constructor method for GroupData
     * @uses GroupData::setGroupDataId()
     * @uses GroupData::setCode()
     * @uses GroupData::setDescription()
     * @uses GroupData::setIsActive()
     * @uses GroupData::setUseAirportSecurity()
     * @uses GroupData::setUseResChannelSecurity()
     * @uses GroupData::setAirports()
     * @uses GroupData::setReservationChannels()
     * @param int $groupDataId
     * @param string $code
     * @param string $description
     * @param int $isActive
     * @param int $useAirportSecurity
     * @param int $useResChannelSecurity
     * @param \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataAirport $airports
     * @param \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataResChannel $reservationChannels
     */
    public function __construct($groupDataId = null, $code = null, $description = null, $isActive = null, $useAirportSecurity = null, $useResChannelSecurity = null, \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataAirport $airports = null, \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataResChannel $reservationChannels = null)
    {
        $this
            ->setGroupDataId($groupDataId)
            ->setCode($code)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setUseAirportSecurity($useAirportSecurity)
            ->setUseResChannelSecurity($useResChannelSecurity)
            ->setAirports($airports)
            ->setReservationChannels($reservationChannels);
    }
    /**
     * Get GroupDataId value
     * @return int|null
     */
    public function getGroupDataId()
    {
        return $this->GroupDataId;
    }
    /**
     * Set GroupDataId value
     * @param int $groupDataId
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setGroupDataId($groupDataId = null)
    {
        // validation for constraint: int
        if (!is_null($groupDataId) && !(is_int($groupDataId) || ctype_digit($groupDataId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupDataId, true), gettype($groupDataId)), __LINE__);
        }
        $this->GroupDataId = $groupDataId;
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * @return int|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param int $isActive
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: int
        if (!is_null($isActive) && !(is_int($isActive) || ctype_digit($isActive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get UseAirportSecurity value
     * @return int|null
     */
    public function getUseAirportSecurity()
    {
        return $this->UseAirportSecurity;
    }
    /**
     * Set UseAirportSecurity value
     * @param int $useAirportSecurity
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setUseAirportSecurity($useAirportSecurity = null)
    {
        // validation for constraint: int
        if (!is_null($useAirportSecurity) && !(is_int($useAirportSecurity) || ctype_digit($useAirportSecurity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($useAirportSecurity, true), gettype($useAirportSecurity)), __LINE__);
        }
        $this->UseAirportSecurity = $useAirportSecurity;
        return $this;
    }
    /**
     * Get UseResChannelSecurity value
     * @return int|null
     */
    public function getUseResChannelSecurity()
    {
        return $this->UseResChannelSecurity;
    }
    /**
     * Set UseResChannelSecurity value
     * @param int $useResChannelSecurity
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setUseResChannelSecurity($useResChannelSecurity = null)
    {
        // validation for constraint: int
        if (!is_null($useResChannelSecurity) && !(is_int($useResChannelSecurity) || ctype_digit($useResChannelSecurity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($useResChannelSecurity, true), gettype($useResChannelSecurity)), __LINE__);
        }
        $this->UseResChannelSecurity = $useResChannelSecurity;
        return $this;
    }
    /**
     * Get Airports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataAirport|null
     */
    public function getAirports()
    {
        return isset($this->Airports) ? $this->Airports : null;
    }
    /**
     * Set Airports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataAirport $airports
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setAirports(\App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataAirport $airports = null)
    {
        if (is_null($airports) || (is_array($airports) && empty($airports))) {
            unset($this->Airports);
        } else {
            $this->Airports = $airports;
        }
        return $this;
    }
    /**
     * Get ReservationChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataResChannel|null
     */
    public function getReservationChannels()
    {
        return isset($this->ReservationChannels) ? $this->ReservationChannels : null;
    }
    /**
     * Set ReservationChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataResChannel $reservationChannels
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public function setReservationChannels(\App\Helpers\Airline\SereneAir\Requests\ArrayType\ArrayOfGroupDataResChannel $reservationChannels = null)
    {
        if (is_null($reservationChannels) || (is_array($reservationChannels) && empty($reservationChannels))) {
            unset($this->ReservationChannels);
        } else {
            $this->ReservationChannels = $reservationChannels;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
