<?php

namespace App\Helpers\Airline\SereneAir\Requests\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupDataResChannel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupDataResChannel
 * @subpackage Structs
 */
class GroupDataResChannel extends AbstractStructBase
{
    /**
     * The ResChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResChannel;
    /**
     * Constructor method for GroupDataResChannel
     * @uses GroupDataResChannel::setResChannel()
     * @param string $resChannel
     */
    public function __construct($resChannel = null)
    {
        $this
            ->setResChannel($resChannel);
    }
    /**
     * Get ResChannel value
     * @return string|null
     */
    public function getResChannel()
    {
        return $this->ResChannel;
    }
    /**
     * Set ResChannel value
     * @uses \App\Helpers\Airline\SereneAir\Requests\EnumType\Enumerations_ReservationChannelTypes::valueIsValid()
     * @uses \App\Helpers\Airline\SereneAir\Requests\EnumType\Enumerations_ReservationChannelTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resChannel
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupDataResChannel
     */
    public function setResChannel($resChannel = null)
    {
        // validation for constraint: enumeration
        if (!\App\Helpers\Airline\SereneAir\Requests\EnumType\Enumerations_ReservationChannelTypes::valueIsValid($resChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Helpers\Airline\SereneAir\Requests\EnumType\Enumerations_ReservationChannelTypes', is_array($resChannel) ? implode(', ', $resChannel) : var_export($resChannel, true), implode(', ', \App\Helpers\Airline\SereneAir\Requests\EnumType\Enumerations_ReservationChannelTypes::getValidValues())), __LINE__);
        }
        $this->ResChannel = $resChannel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupDataResChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
