<?php

namespace App\Helpers\Airline\SereneAir\Requests\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupDataAirport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupDataAirport
 * @subpackage Structs
 */
class GroupDataAirport extends AbstractStructBase
{
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirportCode;
    /**
     * Constructor method for GroupDataAirport
     * @uses GroupDataAirport::setAirportCode()
     * @param string $airportCode
     */
    public function __construct($airportCode = null)
    {
        $this
            ->setAirportCode($airportCode);
    }
    /**
     * Get AirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirportCode()
    {
        return isset($this->AirportCode) ? $this->AirportCode : null;
    }
    /**
     * Set AirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airportCode
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupDataAirport
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        if (is_null($airportCode) || (is_array($airportCode) && empty($airportCode))) {
            unset($this->AirportCode);
        } else {
            $this->AirportCode = $airportCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\GroupDataAirport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
