<?php

namespace App\Helpers\Airline\SereneAir\Requests\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CarrierCode
 * @subpackage Structs
 */
class CarrierCode extends AbstractStructBase
{
    /**
     * The AccessibleCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccessibleCarrierCode;
    /**
     * Constructor method for CarrierCode
     * @uses CarrierCode::setAccessibleCarrierCode()
     * @param string $accessibleCarrierCode
     */
    public function __construct($accessibleCarrierCode = null)
    {
        $this
            ->setAccessibleCarrierCode($accessibleCarrierCode);
    }
    /**
     * Get AccessibleCarrierCode value
     * @return string|null
     */
    public function getAccessibleCarrierCode()
    {
        return $this->AccessibleCarrierCode;
    }
    /**
     * Set AccessibleCarrierCode value
     * @param string $accessibleCarrierCode
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\CarrierCode
     */
    public function setAccessibleCarrierCode($accessibleCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($accessibleCarrierCode) && !is_string($accessibleCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessibleCarrierCode, true), gettype($accessibleCarrierCode)), __LINE__);
        }
        $this->AccessibleCarrierCode = $accessibleCarrierCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\CarrierCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
