<?php

namespace App\Helpers\Airline\SereneAir\Requests\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveSecurityToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Helpers\Airline\SereneAir\Requests\StructType\RetrieveSecurityToken $parameters
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\RetrieveSecurityTokenResponse|bool
     */
    public function RetrieveSecurityToken(\App\Helpers\Airline\SereneAir\Requests\StructType\RetrieveSecurityToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSecurityToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Helpers\Airline\SereneAir\Requests\StructType\RetrieveSecurityTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
