<?php

namespace App\Helpers\Airline\SereneAir\Requests\EnumType;

/**
 * This class stands for ExceptionLevels EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionLevels
 * @subpackage Enumerations
 */
class ExceptionLevels
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Critical'
     * @return string 'Critical'
     */
    const VALUE_CRITICAL = 'Critical';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_CRITICAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_WARNING,
            self::VALUE_CRITICAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
