<?php

namespace App\Helpers\Airline\SereneAir\Requests\EnumType;

/**
 * This class stands for Enumerations.ReservationChannelTypes EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Enumerations.ReservationChannelTypes
 * @subpackage Enumerations
 */
class Enumerations_ReservationChannelTypes
{
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Constant for value 'WEB'
     * @return string 'WEB'
     */
    const VALUE_WEB = 'WEB';
    /**
     * Constant for value 'GDS'
     * @return string 'GDS'
     */
    const VALUE_GDS = 'GDS';
    /**
     * Constant for value 'TPAPI'
     * @return string 'TPAPI'
     */
    const VALUE_TPAPI = 'TPAPI';
    /**
     * Constant for value 'DCS'
     * @return string 'DCS'
     */
    const VALUE_DCS = 'DCS';
    /**
     * Constant for value 'EXT_WEB'
     * @return string 'EXT_WEB'
     */
    const VALUE_EXT_WEB = 'EXT_WEB';
    /**
     * Constant for value 'PNRIMPORT'
     * @return string 'PNRIMPORT'
     */
    const VALUE_PNRIMPORT = 'PNRIMPORT';
    /**
     * Constant for value 'MOBILE'
     * @return string 'MOBILE'
     */
    const VALUE_MOBILE = 'MOBILE';
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'MYIDTRAVEL'
     * @return string 'MYIDTRAVEL'
     */
    const VALUE_MYIDTRAVEL = 'MYIDTRAVEL';
    /**
     * Constant for value 'KIOSK'
     * @return string 'KIOSK'
     */
    const VALUE_KIOSK = 'KIOSK';
    /**
     * Constant for value 'PNLIMPORT'
     * @return string 'PNLIMPORT'
     */
    const VALUE_PNLIMPORT = 'PNLIMPORT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_WEB
     * @uses self::VALUE_GDS
     * @uses self::VALUE_TPAPI
     * @uses self::VALUE_DCS
     * @uses self::VALUE_EXT_WEB
     * @uses self::VALUE_PNRIMPORT
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_ALL
     * @uses self::VALUE_MYIDTRAVEL
     * @uses self::VALUE_KIOSK
     * @uses self::VALUE_PNLIMPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_WEB,
            self::VALUE_GDS,
            self::VALUE_TPAPI,
            self::VALUE_DCS,
            self::VALUE_EXT_WEB,
            self::VALUE_PNRIMPORT,
            self::VALUE_MOBILE,
            self::VALUE_ALL,
            self::VALUE_MYIDTRAVEL,
            self::VALUE_KIOSK,
            self::VALUE_PNLIMPORT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
