<?php

namespace EnumType;

/**
 * This class stands for Language EnumType
 * @subpackage Enumerations
 */
class Language
{
    /**
     * Constant for value 'ln_Hebrew'
     * @return string 'ln_Hebrew'
     */
    const VALUE_LN_HEBREW = 'ln_Hebrew';
    /**
     * Constant for value 'ln_Spanish_Ar'
     * @return string 'ln_Spanish_Ar'
     */
    const VALUE_LN_SPANISH_AR = 'ln_Spanish_Ar';
    /**
     * Constant for value 'ln_English'
     * @return string 'ln_English'
     */
    const VALUE_LN_ENGLISH = 'ln_English';
    /**
     * Constant for value 'ln_Polish'
     * @return string 'ln_Polish'
     */
    const VALUE_LN_POLISH = 'ln_Polish';
    /**
     * Constant for value 'ln_English_Sg'
     * @return string 'ln_English_Sg'
     */
    const VALUE_LN_ENGLISH_SG = 'ln_English_Sg';
    /**
     * Constant for value 'ln_Spanish_Pa'
     * @return string 'ln_Spanish_Pa'
     */
    const VALUE_LN_SPANISH_PA = 'ln_Spanish_Pa';
    /**
     * Constant for value 'ln_English_Gb'
     * @return string 'ln_English_Gb'
     */
    const VALUE_LN_ENGLISH_GB = 'ln_English_Gb';
    /**
     * Constant for value 'ln_German'
     * @return string 'ln_German'
     */
    const VALUE_LN_GERMAN = 'ln_German';
    /**
     * Constant for value 'ln_Serbian'
     * @return string 'ln_Serbian'
     */
    const VALUE_LN_SERBIAN = 'ln_Serbian';
    /**
     * Constant for value 'ln_Danish'
     * @return string 'ln_Danish'
     */
    const VALUE_LN_DANISH = 'ln_Danish';
    /**
     * Constant for value 'ln_Norwegian'
     * @return string 'ln_Norwegian'
     */
    const VALUE_LN_NORWEGIAN = 'ln_Norwegian';
    /**
     * Constant for value 'ln_Italian'
     * @return string 'ln_Italian'
     */
    const VALUE_LN_ITALIAN = 'ln_Italian';
    /**
     * Constant for value 'ln_Hungarian'
     * @return string 'ln_Hungarian'
     */
    const VALUE_LN_HUNGARIAN = 'ln_Hungarian';
    /**
     * Constant for value 'ln_Chinese'
     * @return string 'ln_Chinese'
     */
    const VALUE_LN_CHINESE = 'ln_Chinese';
    /**
     * Constant for value 'ln_Dutch'
     * @return string 'ln_Dutch'
     */
    const VALUE_LN_DUTCH = 'ln_Dutch';
    /**
     * Constant for value 'ln_Finnish'
     * @return string 'ln_Finnish'
     */
    const VALUE_LN_FINNISH = 'ln_Finnish';
    /**
     * Constant for value 'ln_Greek'
     * @return string 'ln_Greek'
     */
    const VALUE_LN_GREEK = 'ln_Greek';
    /**
     * Constant for value 'ln_Portuguese'
     * @return string 'ln_Portuguese'
     */
    const VALUE_LN_PORTUGUESE = 'ln_Portuguese';
    /**
     * Constant for value 'ln_Swedish'
     * @return string 'ln_Swedish'
     */
    const VALUE_LN_SWEDISH = 'ln_Swedish';
    /**
     * Constant for value 'ln_English_Cy'
     * @return string 'ln_English_Cy'
     */
    const VALUE_LN_ENGLISH_CY = 'ln_English_Cy';
    /**
     * Constant for value 'ln_French'
     * @return string 'ln_French'
     */
    const VALUE_LN_FRENCH = 'ln_French';
    /**
     * Constant for value 'ln_Spanish'
     * @return string 'ln_Spanish'
     */
    const VALUE_LN_SPANISH = 'ln_Spanish';
    /**
     * Constant for value 'ln_Russian'
     * @return string 'ln_Russian'
     */
    const VALUE_LN_RUSSIAN = 'ln_Russian';
    /**
     * Constant for value 'ln_Spanish_La'
     * @return string 'ln_Spanish_La'
     */
    const VALUE_LN_SPANISH_LA = 'ln_Spanish_La';
    /**
     * Constant for value 'ln_Czech_Cz'
     * @return string 'ln_Czech_Cz'
     */
    const VALUE_LN_CZECH_CZ = 'ln_Czech_Cz';
    /**
     * Constant for value 'ln_Slovak_Sk'
     * @return string 'ln_Slovak_Sk'
     */
    const VALUE_LN_SLOVAK_SK = 'ln_Slovak_Sk';
    /**
     * Constant for value 'ln_Korean_Kr'
     * @return string 'ln_Korean_Kr'
     */
    const VALUE_LN_KOREAN_KR = 'ln_Korean_Kr';
    /**
     * Constant for value 'ln_Portuguese_Br'
     * @return string 'ln_Portuguese_Br'
     */
    const VALUE_LN_PORTUGUESE_BR = 'ln_Portuguese_Br';
    /**
     * Constant for value 'ln_Japanese_Jp'
     * @return string 'ln_Japanese_Jp'
     */
    const VALUE_LN_JAPANESE_JP = 'ln_Japanese_Jp';
    /**
     * Constant for value 'ln_Turkish_Tr'
     * @return string 'ln_Turkish_Tr'
     */
    const VALUE_LN_TURKISH_TR = 'ln_Turkish_Tr';
    /**
     * Constant for value 'ln_TrdtnlChinese_Hk'
     * @return string 'ln_TrdtnlChinese_Hk'
     */
    const VALUE_LN_TRDTNL_CHINESE_HK = 'ln_TrdtnlChinese_Hk';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LN_HEBREW
     * @uses self::VALUE_LN_SPANISH_AR
     * @uses self::VALUE_LN_ENGLISH
     * @uses self::VALUE_LN_POLISH
     * @uses self::VALUE_LN_ENGLISH_SG
     * @uses self::VALUE_LN_SPANISH_PA
     * @uses self::VALUE_LN_ENGLISH_GB
     * @uses self::VALUE_LN_GERMAN
     * @uses self::VALUE_LN_SERBIAN
     * @uses self::VALUE_LN_DANISH
     * @uses self::VALUE_LN_NORWEGIAN
     * @uses self::VALUE_LN_ITALIAN
     * @uses self::VALUE_LN_HUNGARIAN
     * @uses self::VALUE_LN_CHINESE
     * @uses self::VALUE_LN_DUTCH
     * @uses self::VALUE_LN_FINNISH
     * @uses self::VALUE_LN_GREEK
     * @uses self::VALUE_LN_PORTUGUESE
     * @uses self::VALUE_LN_SWEDISH
     * @uses self::VALUE_LN_ENGLISH_CY
     * @uses self::VALUE_LN_FRENCH
     * @uses self::VALUE_LN_SPANISH
     * @uses self::VALUE_LN_RUSSIAN
     * @uses self::VALUE_LN_SPANISH_LA
     * @uses self::VALUE_LN_CZECH_CZ
     * @uses self::VALUE_LN_SLOVAK_SK
     * @uses self::VALUE_LN_KOREAN_KR
     * @uses self::VALUE_LN_PORTUGUESE_BR
     * @uses self::VALUE_LN_JAPANESE_JP
     * @uses self::VALUE_LN_TURKISH_TR
     * @uses self::VALUE_LN_TRDTNL_CHINESE_HK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LN_HEBREW,
            self::VALUE_LN_SPANISH_AR,
            self::VALUE_LN_ENGLISH,
            self::VALUE_LN_POLISH,
            self::VALUE_LN_ENGLISH_SG,
            self::VALUE_LN_SPANISH_PA,
            self::VALUE_LN_ENGLISH_GB,
            self::VALUE_LN_GERMAN,
            self::VALUE_LN_SERBIAN,
            self::VALUE_LN_DANISH,
            self::VALUE_LN_NORWEGIAN,
            self::VALUE_LN_ITALIAN,
            self::VALUE_LN_HUNGARIAN,
            self::VALUE_LN_CHINESE,
            self::VALUE_LN_DUTCH,
            self::VALUE_LN_FINNISH,
            self::VALUE_LN_GREEK,
            self::VALUE_LN_PORTUGUESE,
            self::VALUE_LN_SWEDISH,
            self::VALUE_LN_ENGLISH_CY,
            self::VALUE_LN_FRENCH,
            self::VALUE_LN_SPANISH,
            self::VALUE_LN_RUSSIAN,
            self::VALUE_LN_SPANISH_LA,
            self::VALUE_LN_CZECH_CZ,
            self::VALUE_LN_SLOVAK_SK,
            self::VALUE_LN_KOREAN_KR,
            self::VALUE_LN_PORTUGUESE_BR,
            self::VALUE_LN_JAPANESE_JP,
            self::VALUE_LN_TURKISH_TR,
            self::VALUE_LN_TRDTNL_CHINESE_HK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
