<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The DatabaseServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseServer;
    /**
     * The DatabaseName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseName;
    /**
     * The DatabaseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseType;
    /**
     * The CompanyUsername
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyUsername;
    /**
     * The CompanyPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyPassword;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The LicenseServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicenseServer;
    /**
     * Constructor method for Login
     * @uses Login::setDatabaseServer()
     * @uses Login::setDatabaseName()
     * @uses Login::setDatabaseType()
     * @uses Login::setCompanyUsername()
     * @uses Login::setCompanyPassword()
     * @uses Login::setLanguage()
     * @uses Login::setLicenseServer()
     * @param string $databaseServer
     * @param string $databaseName
     * @param string $databaseType
     * @param string $companyUsername
     * @param string $companyPassword
     * @param string $language
     * @param string $licenseServer
     */
    public function __construct($databaseServer = null, $databaseName = null, $databaseType = null, $companyUsername = null, $companyPassword = null, $language = null, $licenseServer = null)
    {
        $this
            ->setDatabaseServer($databaseServer)
            ->setDatabaseName($databaseName)
            ->setDatabaseType($databaseType)
            ->setCompanyUsername($companyUsername)
            ->setCompanyPassword($companyPassword)
            ->setLanguage($language)
            ->setLicenseServer($licenseServer);
    }
    /**
     * Get DatabaseServer value
     * @return string|null
     */
    public function getDatabaseServer()
    {
        return $this->DatabaseServer;
    }
    /**
     * Set DatabaseServer value
     * @param string $databaseServer
     * @return \StructType\Login
     */
    public function setDatabaseServer($databaseServer = null)
    {
        // validation for constraint: string
        if (!is_null($databaseServer) && !is_string($databaseServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseServer)), __LINE__);
        }
        $this->DatabaseServer = $databaseServer;
        return $this;
    }
    /**
     * Get DatabaseName value
     * @return string|null
     */
    public function getDatabaseName()
    {
        return $this->DatabaseName;
    }
    /**
     * Set DatabaseName value
     * @param string $databaseName
     * @return \StructType\Login
     */
    public function setDatabaseName($databaseName = null)
    {
        // validation for constraint: string
        if (!is_null($databaseName) && !is_string($databaseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseName)), __LINE__);
        }
        $this->DatabaseName = $databaseName;
        return $this;
    }
    /**
     * Get DatabaseType value
     * @return string|null
     */
    public function getDatabaseType()
    {
        return $this->DatabaseType;
    }
    /**
     * Set DatabaseType value
     * @uses \EnumType\DatabaseType::valueIsValid()
     * @uses \EnumType\DatabaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $databaseType
     * @return \StructType\Login
     */
    public function setDatabaseType($databaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatabaseType::valueIsValid($databaseType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $databaseType, implode(', ', \EnumType\DatabaseType::getValidValues())), __LINE__);
        }
        $this->DatabaseType = $databaseType;
        return $this;
    }
    /**
     * Get CompanyUsername value
     * @return string|null
     */
    public function getCompanyUsername()
    {
        return $this->CompanyUsername;
    }
    /**
     * Set CompanyUsername value
     * @param string $companyUsername
     * @return \StructType\Login
     */
    public function setCompanyUsername($companyUsername = null)
    {
        // validation for constraint: string
        if (!is_null($companyUsername) && !is_string($companyUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyUsername)), __LINE__);
        }
        $this->CompanyUsername = $companyUsername;
        return $this;
    }
    /**
     * Get CompanyPassword value
     * @return string|null
     */
    public function getCompanyPassword()
    {
        return $this->CompanyPassword;
    }
    /**
     * Set CompanyPassword value
     * @param string $companyPassword
     * @return \StructType\Login
     */
    public function setCompanyPassword($companyPassword = null)
    {
        // validation for constraint: string
        if (!is_null($companyPassword) && !is_string($companyPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyPassword)), __LINE__);
        }
        $this->CompanyPassword = $companyPassword;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\Login
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $language, implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get LicenseServer value
     * @return string|null
     */
    public function getLicenseServer()
    {
        return $this->LicenseServer;
    }
    /**
     * Set LicenseServer value
     * @param string $licenseServer
     * @return \StructType\Login
     */
    public function setLicenseServer($licenseServer = null)
    {
        // validation for constraint: string
        if (!is_null($licenseServer) && !is_string($licenseServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseServer)), __LINE__);
        }
        $this->LicenseServer = $licenseServer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Login
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
