<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Logout ServiceType
 * @subpackage Services
 */
class Logout extends AbstractSoapClientBase
{
    /**
     * Sets the MsgHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\MsgHeader $msgHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMsgHeader(\StructType\MsgHeader $msgHeader, $nameSpace = 'http://www.sap.com/SBO/DIS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MsgHeader', $msgHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Logout
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: MsgHeader
     * - SOAPHeaderNamespaces: http://www.sap.com/SBO/DIS
     * - SOAPHeaderTypes: \StructType\MsgHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Logout $parameters
     * @return \StructType\LogoutResponse|bool
     */
    public function Logout(\StructType\Logout $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Logout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LogoutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
