<?php

namespace EnumType;

/**
 * This class stands for DatabaseType EnumType
 * @subpackage Enumerations
 */
class DatabaseType
{
    /**
     * Constant for value 'dst_MSSQL'
     * @return string 'dst_MSSQL'
     */
    const VALUE_DST_MSSQL = 'dst_MSSQL';
    /**
     * Constant for value 'dst_DB_2'
     * @return string 'dst_DB_2'
     */
    const VALUE_DST_DB_2 = 'dst_DB_2';
    /**
     * Constant for value 'dst_SYBASE'
     * @return string 'dst_SYBASE'
     */
    const VALUE_DST_SYBASE = 'dst_SYBASE';
    /**
     * Constant for value 'dst_MSSQL2005'
     * @return string 'dst_MSSQL2005'
     */
    const VALUE_DST_MSSQL_2005 = 'dst_MSSQL2005';
    /**
     * Constant for value 'dst_MAXDB'
     * @return string 'dst_MAXDB'
     */
    const VALUE_DST_MAXDB = 'dst_MAXDB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DST_MSSQL
     * @uses self::VALUE_DST_DB_2
     * @uses self::VALUE_DST_SYBASE
     * @uses self::VALUE_DST_MSSQL_2005
     * @uses self::VALUE_DST_MAXDB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DST_MSSQL,
            self::VALUE_DST_DB_2,
            self::VALUE_DST_SYBASE,
            self::VALUE_DST_MSSQL_2005,
            self::VALUE_DST_MAXDB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
