<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dev.gittigidiyor.com:8080/listingapi/ws/IndividualCargoService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dev.gittigidiyor.com:8080/listingapi/ws/IndividualCargoService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelShippingRequest operation/method
 */
if ($cancel->cancelShippingRequest($apiKey, $sign, $time, $lang, $saleCode) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createShippingRequest operation/method
 */
if ($create->createShippingRequest($apiKey, $sign, $time, $lang, $saleCode, $shippingFirmId) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getCargoCompany operation/method
 */
if ($get->getCargoCompany($apiKey, $sign, $time, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCargoInformation operation/method
 */
if ($get->getCargoInformation($apiKey, $sign, $time, $saleCode, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServiceName operation/method
 */
if ($get->getServiceName() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getShippingRequest operation/method
 */
if ($get->getShippingRequest($apiKey, $sign, $time, $lang, $saleCode) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendCargoInformation operation/method
 */
if ($send->sendCargoInformation($apiKey, $sign, $time, $saleCode, $cargoPostCode, $cargoCompany, $cargoBranch, $followUpUrl, $userType, $lang) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
