<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingRequestType StructType
 * @subpackage Structs
 */
class ShippingRequestType extends AbstractStructBase
{
    /**
     * The saleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $saleId;
    /**
     * The firmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $firmId;
    /**
     * The isCancelled
     * @var bool
     */
    public $isCancelled;
    /**
     * Constructor method for shippingRequestType
     * @uses ShippingRequestType::setSaleId()
     * @uses ShippingRequestType::setFirmId()
     * @uses ShippingRequestType::setIsCancelled()
     * @param int $saleId
     * @param int $firmId
     * @param bool $isCancelled
     */
    public function __construct($saleId = null, $firmId = null, $isCancelled = null)
    {
        $this
            ->setSaleId($saleId)
            ->setFirmId($firmId)
            ->setIsCancelled($isCancelled);
    }
    /**
     * Get saleId value
     * @return int|null
     */
    public function getSaleId()
    {
        return $this->saleId;
    }
    /**
     * Set saleId value
     * @param int $saleId
     * @return \StructType\ShippingRequestType
     */
    public function setSaleId($saleId = null)
    {
        // validation for constraint: int
        if (!is_null($saleId) && !(is_int($saleId) || ctype_digit($saleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleId, true), gettype($saleId)), __LINE__);
        }
        $this->saleId = $saleId;
        return $this;
    }
    /**
     * Get firmId value
     * @return int|null
     */
    public function getFirmId()
    {
        return $this->firmId;
    }
    /**
     * Set firmId value
     * @param int $firmId
     * @return \StructType\ShippingRequestType
     */
    public function setFirmId($firmId = null)
    {
        // validation for constraint: int
        if (!is_null($firmId) && !(is_int($firmId) || ctype_digit($firmId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firmId, true), gettype($firmId)), __LINE__);
        }
        $this->firmId = $firmId;
        return $this;
    }
    /**
     * Get isCancelled value
     * @return bool|null
     */
    public function getIsCancelled()
    {
        return $this->isCancelled;
    }
    /**
     * Set isCancelled value
     * @param bool $isCancelled
     * @return \StructType\ShippingRequestType
     */
    public function setIsCancelled($isCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCancelled) && !is_bool($isCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCancelled, true), gettype($isCancelled)), __LINE__);
        }
        $this->isCancelled = $isCancelled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
