<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cargoInformationResponse StructType
 * @subpackage Structs
 */
class CargoInformationResponse extends BaseResponse
{
    /**
     * The cargoPostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoPostCode;
    /**
     * The cargoContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoContent;
    /**
     * Constructor method for cargoInformationResponse
     * @uses CargoInformationResponse::setCargoPostCode()
     * @uses CargoInformationResponse::setCargoContent()
     * @param string $cargoPostCode
     * @param string $cargoContent
     */
    public function __construct($cargoPostCode = null, $cargoContent = null)
    {
        $this
            ->setCargoPostCode($cargoPostCode)
            ->setCargoContent($cargoContent);
    }
    /**
     * Get cargoPostCode value
     * @return string|null
     */
    public function getCargoPostCode()
    {
        return $this->cargoPostCode;
    }
    /**
     * Set cargoPostCode value
     * @param string $cargoPostCode
     * @return \StructType\CargoInformationResponse
     */
    public function setCargoPostCode($cargoPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($cargoPostCode) && !is_string($cargoPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoPostCode, true), gettype($cargoPostCode)), __LINE__);
        }
        $this->cargoPostCode = $cargoPostCode;
        return $this;
    }
    /**
     * Get cargoContent value
     * @return string|null
     */
    public function getCargoContent()
    {
        return $this->cargoContent;
    }
    /**
     * Set cargoContent value
     * @param string $cargoContent
     * @return \StructType\CargoInformationResponse
     */
    public function setCargoContent($cargoContent = null)
    {
        // validation for constraint: string
        if (!is_null($cargoContent) && !is_string($cargoContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoContent, true), gettype($cargoContent)), __LINE__);
        }
        $this->cargoContent = $cargoContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CargoInformationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
