<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cargoCompanyResponse StructType
 * @subpackage Structs
 */
class CargoCompanyResponse extends BaseResponse
{
    /**
     * The userShippingCompanyTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserShippingCompanyType[]
     */
    public $userShippingCompanyTypes;
    /**
     * Constructor method for cargoCompanyResponse
     * @uses CargoCompanyResponse::setUserShippingCompanyTypes()
     * @param \StructType\UserShippingCompanyType[] $userShippingCompanyTypes
     */
    public function __construct(array $userShippingCompanyTypes = array())
    {
        $this
            ->setUserShippingCompanyTypes($userShippingCompanyTypes);
    }
    /**
     * Get userShippingCompanyTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserShippingCompanyType[]|null
     */
    public function getUserShippingCompanyTypes()
    {
        return isset($this->userShippingCompanyTypes) ? $this->userShippingCompanyTypes : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUserShippingCompanyTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserShippingCompanyTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserShippingCompanyTypesForArrayConstraintsFromSetUserShippingCompanyTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cargoCompanyResponseUserShippingCompanyTypesItem) {
            // validation for constraint: itemType
            if (!$cargoCompanyResponseUserShippingCompanyTypesItem instanceof \StructType\UserShippingCompanyType) {
                $invalidValues[] = is_object($cargoCompanyResponseUserShippingCompanyTypesItem) ? get_class($cargoCompanyResponseUserShippingCompanyTypesItem) : sprintf('%s(%s)', gettype($cargoCompanyResponseUserShippingCompanyTypesItem), var_export($cargoCompanyResponseUserShippingCompanyTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The userShippingCompanyTypes property can only contain items of type \StructType\UserShippingCompanyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set userShippingCompanyTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserShippingCompanyType[] $userShippingCompanyTypes
     * @return \StructType\CargoCompanyResponse
     */
    public function setUserShippingCompanyTypes(array $userShippingCompanyTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($userShippingCompanyTypesArrayErrorMessage = self::validateUserShippingCompanyTypesForArrayConstraintsFromSetUserShippingCompanyTypes($userShippingCompanyTypes))) {
            throw new \InvalidArgumentException($userShippingCompanyTypesArrayErrorMessage, __LINE__);
        }
        if (is_null($userShippingCompanyTypes) || (is_array($userShippingCompanyTypes) && empty($userShippingCompanyTypes))) {
            unset($this->userShippingCompanyTypes);
        } else {
            $this->userShippingCompanyTypes = $userShippingCompanyTypes;
        }
        return $this;
    }
    /**
     * Add item to userShippingCompanyTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\UserShippingCompanyType $item
     * @return \StructType\CargoCompanyResponse
     */
    public function addToUserShippingCompanyTypes(\StructType\UserShippingCompanyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserShippingCompanyType) {
            throw new \InvalidArgumentException(sprintf('The userShippingCompanyTypes property can only contain items of type \StructType\UserShippingCompanyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->userShippingCompanyTypes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CargoCompanyResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
