<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendCargoInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $cargoPostCode
     * @param string $cargoCompany
     * @param string $cargoBranch
     * @param string $followUpUrl
     * @param string $userType
     * @param string $lang
     * @return \StructType\CommonSaleResponse|bool
     */
    public function sendCargoInformation($apiKey, $sign, $time, $saleCode, $cargoPostCode, $cargoCompany, $cargoBranch, $followUpUrl, $userType, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->sendCargoInformation($apiKey, $sign, $time, $saleCode, $cargoPostCode, $cargoCompany, $cargoBranch, $followUpUrl, $userType, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CommonSaleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
