<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userShippingCompanyType StructType
 * @subpackage Structs
 */
class UserShippingCompanyType extends AbstractStructBase
{
    /**
     * The shippingFirmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shippingFirmId;
    /**
     * The shippingFirmName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingFirmName;
    /**
     * Constructor method for userShippingCompanyType
     * @uses UserShippingCompanyType::setShippingFirmId()
     * @uses UserShippingCompanyType::setShippingFirmName()
     * @param int $shippingFirmId
     * @param string $shippingFirmName
     */
    public function __construct($shippingFirmId = null, $shippingFirmName = null)
    {
        $this
            ->setShippingFirmId($shippingFirmId)
            ->setShippingFirmName($shippingFirmName);
    }
    /**
     * Get shippingFirmId value
     * @return int|null
     */
    public function getShippingFirmId()
    {
        return $this->shippingFirmId;
    }
    /**
     * Set shippingFirmId value
     * @param int $shippingFirmId
     * @return \StructType\UserShippingCompanyType
     */
    public function setShippingFirmId($shippingFirmId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingFirmId) && !(is_int($shippingFirmId) || ctype_digit($shippingFirmId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingFirmId, true), gettype($shippingFirmId)), __LINE__);
        }
        $this->shippingFirmId = $shippingFirmId;
        return $this;
    }
    /**
     * Get shippingFirmName value
     * @return string|null
     */
    public function getShippingFirmName()
    {
        return $this->shippingFirmName;
    }
    /**
     * Set shippingFirmName value
     * @param string $shippingFirmName
     * @return \StructType\UserShippingCompanyType
     */
    public function setShippingFirmName($shippingFirmName = null)
    {
        // validation for constraint: string
        if (!is_null($shippingFirmName) && !is_string($shippingFirmName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingFirmName, true), gettype($shippingFirmName)), __LINE__);
        }
        $this->shippingFirmName = $shippingFirmName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserShippingCompanyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
