<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userConversationsLoadingResponse StructType
 * @subpackage Structs
 */
class UserConversationsLoadingResponse extends BaseResponse
{
    /**
     * The conversationsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $conversationsCount;
    /**
     * The conversations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Conversations
     */
    public $conversations;
    /**
     * Constructor method for userConversationsLoadingResponse
     * @uses UserConversationsLoadingResponse::setConversationsCount()
     * @uses UserConversationsLoadingResponse::setConversations()
     * @param int $conversationsCount
     * @param \StructType\Conversations $conversations
     */
    public function __construct($conversationsCount = null, \StructType\Conversations $conversations = null)
    {
        $this
            ->setConversationsCount($conversationsCount)
            ->setConversations($conversations);
    }
    /**
     * Get conversationsCount value
     * @return int|null
     */
    public function getConversationsCount()
    {
        return $this->conversationsCount;
    }
    /**
     * Set conversationsCount value
     * @param int $conversationsCount
     * @return \StructType\UserConversationsLoadingResponse
     */
    public function setConversationsCount($conversationsCount = null)
    {
        // validation for constraint: int
        if (!is_null($conversationsCount) && !(is_int($conversationsCount) || ctype_digit($conversationsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($conversationsCount, true), gettype($conversationsCount)), __LINE__);
        }
        $this->conversationsCount = $conversationsCount;
        return $this;
    }
    /**
     * Get conversations value
     * @return \StructType\Conversations|null
     */
    public function getConversations()
    {
        return $this->conversations;
    }
    /**
     * Set conversations value
     * @param \StructType\Conversations $conversations
     * @return \StructType\UserConversationsLoadingResponse
     */
    public function setConversations(\StructType\Conversations $conversations = null)
    {
        $this->conversations = $conversations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserConversationsLoadingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
