<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userConversationCountType StructType
 * @subpackage Structs
 */
class UserConversationCountType extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The conversationCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $conversationCount;
    /**
     * Constructor method for userConversationCountType
     * @uses UserConversationCountType::setType()
     * @uses UserConversationCountType::setConversationCount()
     * @param string $type
     * @param int $conversationCount
     */
    public function __construct($type = null, $conversationCount = null)
    {
        $this
            ->setType($type)
            ->setConversationCount($conversationCount);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\UserConversationCountType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get conversationCount value
     * @return int|null
     */
    public function getConversationCount()
    {
        return $this->conversationCount;
    }
    /**
     * Set conversationCount value
     * @param int $conversationCount
     * @return \StructType\UserConversationCountType
     */
    public function setConversationCount($conversationCount = null)
    {
        // validation for constraint: int
        if (!is_null($conversationCount) && !(is_int($conversationCount) || ctype_digit($conversationCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($conversationCount, true), gettype($conversationCount)), __LINE__);
        }
        $this->conversationCount = $conversationCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserConversationCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
