<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userConversationCountResponse StructType
 * @subpackage Structs
 */
class UserConversationCountResponse extends BaseResponse
{
    /**
     * The totalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalCount;
    /**
     * The userConversationCountTypeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserConversationCountTypeList
     */
    public $userConversationCountTypeList;
    /**
     * Constructor method for userConversationCountResponse
     * @uses UserConversationCountResponse::setTotalCount()
     * @uses UserConversationCountResponse::setUserConversationCountTypeList()
     * @param int $totalCount
     * @param \StructType\UserConversationCountTypeList $userConversationCountTypeList
     */
    public function __construct($totalCount = null, \StructType\UserConversationCountTypeList $userConversationCountTypeList = null)
    {
        $this
            ->setTotalCount($totalCount)
            ->setUserConversationCountTypeList($userConversationCountTypeList);
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\UserConversationCountResponse
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get userConversationCountTypeList value
     * @return \StructType\UserConversationCountTypeList|null
     */
    public function getUserConversationCountTypeList()
    {
        return $this->userConversationCountTypeList;
    }
    /**
     * Set userConversationCountTypeList value
     * @param \StructType\UserConversationCountTypeList $userConversationCountTypeList
     * @return \StructType\UserConversationCountResponse
     */
    public function setUserConversationCountTypeList(\StructType\UserConversationCountTypeList $userConversationCountTypeList = null)
    {
        $this->userConversationCountTypeList = $userConversationCountTypeList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserConversationCountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
