<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subjects StructType
 * @subpackage Structs
 */
class Subjects extends AbstractStructBase
{
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Subject[]
     */
    public $subject;
    /**
     * Constructor method for subjects
     * @uses Subjects::setSubject()
     * @param \StructType\Subject[] $subject
     */
    public function __construct(array $subject = array())
    {
        $this
            ->setSubject($subject);
    }
    /**
     * Get subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Subject[]|null
     */
    public function getSubject()
    {
        return isset($this->subject) ? $this->subject : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubjectForArrayConstraintsFromSetSubject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subjectsSubjectItem) {
            // validation for constraint: itemType
            if (!$subjectsSubjectItem instanceof \StructType\Subject) {
                $invalidValues[] = is_object($subjectsSubjectItem) ? get_class($subjectsSubjectItem) : sprintf('%s(%s)', gettype($subjectsSubjectItem), var_export($subjectsSubjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subject property can only contain items of type \StructType\Subject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Subject[] $subject
     * @return \StructType\Subjects
     */
    public function setSubject(array $subject = array())
    {
        // validation for constraint: array
        if ('' !== ($subjectArrayErrorMessage = self::validateSubjectForArrayConstraintsFromSetSubject($subject))) {
            throw new \InvalidArgumentException($subjectArrayErrorMessage, __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->subject);
        } else {
            $this->subject = $subject;
        }
        return $this;
    }
    /**
     * Add item to subject value
     * @throws \InvalidArgumentException
     * @param \StructType\Subject $item
     * @return \StructType\Subjects
     */
    public function addToSubject(\StructType\Subject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Subject) {
            throw new \InvalidArgumentException(sprintf('The subject property can only contain items of type \StructType\Subject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subject[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subjects
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
